/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public class SimpleTextTermVectorsWriter
extends TermVectorsWriter {
    static final BytesRef END = new BytesRef("END");
    static final BytesRef DOC = new BytesRef("doc ");
    static final BytesRef NUMFIELDS = new BytesRef("  numfields ");
    static final BytesRef FIELD = new BytesRef("  field ");
    static final BytesRef FIELDNAME = new BytesRef("    name ");
    static final BytesRef FIELDPOSITIONS = new BytesRef("    positions ");
    static final BytesRef FIELDOFFSETS = new BytesRef("    offsets   ");
    static final BytesRef FIELDPAYLOADS = new BytesRef("    payloads  ");
    static final BytesRef FIELDTERMCOUNT = new BytesRef("    numterms ");
    static final BytesRef TERMTEXT = new BytesRef("    term ");
    static final BytesRef TERMFREQ = new BytesRef("      freq ");
    static final BytesRef POSITION = new BytesRef("      position ");
    static final BytesRef PAYLOAD = new BytesRef("        payload ");
    static final BytesRef STARTOFFSET = new BytesRef("        startoffset ");
    static final BytesRef ENDOFFSET = new BytesRef("        endoffset ");
    static final String VECTORS_EXTENSION = "vec";
    private IndexOutput out;
    private int numDocsWritten = 0;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private boolean offsets;
    private boolean positions;
    private boolean payloads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTextTermVectorsWriter(Directory directory, String segment, IOContext context) throws IOException {
        boolean success = false;
        try {
            this.out = directory.createOutput(IndexFileNames.segmentFileName(segment, "", VECTORS_EXTENSION), context);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void startDocument(int numVectorFields) throws IOException {
        this.write(DOC);
        this.write(Integer.toString(this.numDocsWritten));
        this.newLine();
        this.write(NUMFIELDS);
        this.write(Integer.toString(numVectorFields));
        this.newLine();
        ++this.numDocsWritten;
    }

    @Override
    public void startField(FieldInfo info, int numTerms, boolean positions, boolean offsets, boolean payloads) throws IOException {
        this.write(FIELD);
        this.write(Integer.toString(info.number));
        this.newLine();
        this.write(FIELDNAME);
        this.write(info.name);
        this.newLine();
        this.write(FIELDPOSITIONS);
        this.write(Boolean.toString(positions));
        this.newLine();
        this.write(FIELDOFFSETS);
        this.write(Boolean.toString(offsets));
        this.newLine();
        this.write(FIELDPAYLOADS);
        this.write(Boolean.toString(payloads));
        this.newLine();
        this.write(FIELDTERMCOUNT);
        this.write(Integer.toString(numTerms));
        this.newLine();
        this.positions = positions;
        this.offsets = offsets;
        this.payloads = payloads;
    }

    @Override
    public void startTerm(BytesRef term, int freq) throws IOException {
        this.write(TERMTEXT);
        this.write(term);
        this.newLine();
        this.write(TERMFREQ);
        this.write(Integer.toString(freq));
        this.newLine();
    }

    @Override
    public void addPosition(int position, int startOffset, int endOffset, BytesRef payload) throws IOException {
        assert (this.positions || this.offsets);
        if (this.positions) {
            this.write(POSITION);
            this.write(Integer.toString(position));
            this.newLine();
            if (this.payloads) {
                this.write(PAYLOAD);
                if (payload != null) {
                    assert (payload.length > 0);
                    this.write(payload);
                }
                this.newLine();
            }
        }
        if (this.offsets) {
            this.write(STARTOFFSET);
            this.write(Integer.toString(startOffset));
            this.newLine();
            this.write(ENDOFFSET);
            this.write(Integer.toString(endOffset));
            this.newLine();
        }
    }

    @Override
    public void finish(FieldInfos fis, int numDocs) throws IOException {
        if (this.numDocsWritten != numDocs) {
            throw new RuntimeException("mergeVectors produced an invalid result: mergedDocs is " + numDocs + " but vec numDocs is " + this.numDocsWritten + " file=" + this.out.toString() + "; now aborting this merge to prevent index corruption");
        }
        this.write(END);
        this.newLine();
        SimpleTextUtil.writeChecksum(this.out, this.scratch);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.out);
        }
        finally {
            this.out = null;
        }
    }

    private void write(String s) throws IOException {
        SimpleTextUtil.write(this.out, s, this.scratch);
    }

    private void write(BytesRef bytes) throws IOException {
        SimpleTextUtil.write(this.out, bytes);
    }

    private void newLine() throws IOException {
        SimpleTextUtil.writeNewline(this.out);
    }

    @Override
    public long ramBytesUsed() {
        return this.scratch.get().bytes.length;
    }
}

