/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;

public class FieldMetadata
implements Accountable {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(FieldMetadata.class);
    protected final FieldInfo fieldInfo;
    protected final boolean isMutable;
    protected final FixedBitSet docsSeen;
    protected long sumDocFreq;
    protected long numTerms;
    protected long sumTotalTermFreq;
    protected int docCount;
    protected long dictionaryStartFP;
    protected long firstBlockStartFP;
    protected long lastBlockStartFP;
    protected BytesRef lastTerm;

    public FieldMetadata(FieldInfo fieldInfo, int maxDoc) {
        this(fieldInfo, maxDoc, true);
    }

    public FieldMetadata(long dictionaryStartFP, long firstBlockStartFP, long lastBlockStartFP, BytesRef lastTerm) {
        this(null, 0, false);
        this.dictionaryStartFP = dictionaryStartFP;
        this.firstBlockStartFP = firstBlockStartFP;
        this.lastBlockStartFP = lastBlockStartFP;
        this.lastTerm = lastTerm;
    }

    protected FieldMetadata(FieldInfo fieldInfo, int maxDoc, boolean isMutable) {
        assert (isMutable || maxDoc == 0);
        this.fieldInfo = fieldInfo;
        this.isMutable = isMutable;
        this.docsSeen = isMutable ? new FixedBitSet(maxDoc) : null;
        this.dictionaryStartFP = -1L;
        this.firstBlockStartFP = -1L;
        this.lastBlockStartFP = -1L;
    }

    public void updateStats(BlockTermState state) {
        assert (this.isMutable);
        assert (state.docFreq > 0);
        this.sumDocFreq += (long)state.docFreq;
        if (state.totalTermFreq > 0L) {
            this.sumTotalTermFreq += state.totalTermFreq;
        }
        ++this.numTerms;
    }

    public FixedBitSet getDocsSeen() {
        return this.docsSeen;
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    public long getNumTerms() {
        return this.numTerms;
    }

    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public int getDocCount() {
        return this.isMutable ? this.docsSeen.cardinality() : this.docCount;
    }

    public long getFirstBlockStartFP() {
        return this.firstBlockStartFP;
    }

    public void setFirstBlockStartFP(long firstBlockStartFP) {
        assert (this.isMutable);
        this.firstBlockStartFP = firstBlockStartFP;
    }

    public long getLastBlockStartFP() {
        return this.lastBlockStartFP;
    }

    public void setLastBlockStartFP(long lastBlockStartFP) {
        assert (this.isMutable);
        this.lastBlockStartFP = lastBlockStartFP;
    }

    public long getDictionaryStartFP() {
        return this.dictionaryStartFP;
    }

    public void setDictionaryStartFP(long dictionaryStartFP) {
        assert (this.isMutable);
        this.dictionaryStartFP = dictionaryStartFP;
    }

    public void setLastTerm(BytesRef lastTerm) {
        assert (lastTerm != null);
        this.lastTerm = lastTerm;
    }

    public BytesRef getLastTerm() {
        return this.lastTerm;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_USAGE + (this.docsSeen == null ? 0L : this.docsSeen.ramBytesUsed());
    }

    public static class Serializer {
        public static final Serializer INSTANCE = new Serializer();

        public void write(DataOutput output, FieldMetadata fieldMetadata) throws IOException {
            assert (fieldMetadata.dictionaryStartFP >= 0L);
            assert (fieldMetadata.firstBlockStartFP >= 0L);
            assert (fieldMetadata.lastBlockStartFP >= 0L);
            assert (fieldMetadata.numTerms > 0L) : "There should be at least one term for field " + fieldMetadata.fieldInfo.name + ": " + fieldMetadata.numTerms;
            assert (fieldMetadata.firstBlockStartFP <= fieldMetadata.lastBlockStartFP) : "start: " + fieldMetadata.firstBlockStartFP + " end: " + fieldMetadata.lastBlockStartFP;
            assert (fieldMetadata.lastTerm != null) : "you must set the last term";
            output.writeVInt(fieldMetadata.fieldInfo.number);
            output.writeVLong(fieldMetadata.numTerms);
            output.writeVLong(fieldMetadata.sumDocFreq);
            if (fieldMetadata.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0) {
                assert (fieldMetadata.sumTotalTermFreq >= fieldMetadata.sumDocFreq) : "sumTotalFQ: " + fieldMetadata.sumTotalTermFreq + " sumDocFQ: " + fieldMetadata.sumDocFreq;
                output.writeVLong(fieldMetadata.sumTotalTermFreq - fieldMetadata.sumDocFreq);
            }
            output.writeVInt(fieldMetadata.getDocCount());
            output.writeVLong(fieldMetadata.dictionaryStartFP);
            output.writeVLong(fieldMetadata.firstBlockStartFP);
            output.writeVLong(fieldMetadata.lastBlockStartFP);
            if (fieldMetadata.lastTerm.length > 0) {
                output.writeVInt(fieldMetadata.lastTerm.length);
                output.writeBytes(fieldMetadata.lastTerm.bytes, fieldMetadata.lastTerm.offset, fieldMetadata.lastTerm.length);
            } else {
                output.writeVInt(0);
            }
        }

        public FieldMetadata read(DataInput input, FieldInfos fieldInfos, int maxNumDocs) throws IOException {
            int fieldId = input.readVInt();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldId);
            if (fieldInfo == null) {
                throw new CorruptIndexException("Illegal field id= " + fieldId, input);
            }
            FieldMetadata fieldMetadata = new FieldMetadata(fieldInfo, 0, false);
            fieldMetadata.numTerms = input.readVLong();
            if (fieldMetadata.numTerms <= 0L) {
                throw new CorruptIndexException("Illegal number of terms= " + fieldMetadata.numTerms + " for field= " + fieldId, input);
            }
            fieldMetadata.sumTotalTermFreq = fieldMetadata.sumDocFreq = input.readVLong();
            if (fieldMetadata.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0) {
                fieldMetadata.sumTotalTermFreq += input.readVLong();
                if (fieldMetadata.sumTotalTermFreq < fieldMetadata.sumDocFreq) {
                    throw new CorruptIndexException("Illegal sumTotalTermFreq= " + fieldMetadata.sumTotalTermFreq + " sumDocFreq= " + fieldMetadata.sumDocFreq + " for field= " + fieldId, input);
                }
            }
            fieldMetadata.docCount = input.readVInt();
            if (fieldMetadata.docCount < 0 || fieldMetadata.docCount > maxNumDocs) {
                throw new CorruptIndexException("Illegal number of docs= " + fieldMetadata.docCount + " maxNumDocs= " + maxNumDocs + " for field=" + fieldId, input);
            }
            if (fieldMetadata.sumDocFreq < (long)fieldMetadata.docCount) {
                throw new CorruptIndexException("Illegal sumDocFreq= " + fieldMetadata.sumDocFreq + " docCount= " + fieldMetadata.docCount + " for field= " + fieldId, input);
            }
            fieldMetadata.dictionaryStartFP = input.readVLong();
            fieldMetadata.firstBlockStartFP = input.readVLong();
            fieldMetadata.lastBlockStartFP = input.readVLong();
            int lastTermLength = input.readVInt();
            BytesRef lastTerm = new BytesRef(lastTermLength);
            if (lastTermLength > 0) {
                input.readBytes(lastTerm.bytes, 0, lastTermLength);
                lastTerm.length = lastTermLength;
            } else if (lastTermLength < 0) {
                throw new CorruptIndexException("Illegal last term length= " + lastTermLength + " for field= " + fieldId, input);
            }
            fieldMetadata.setLastTerm(lastTerm);
            return fieldMetadata;
        }
    }
}

