/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockReader;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.IntersectBlockReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class UniformSplitTerms
extends Terms
implements Accountable {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(UniformSplitTerms.class);
    protected final IndexInput blockInput;
    protected final FieldMetadata fieldMetadata;
    protected final PostingsReaderBase postingsReader;
    protected final BlockDecoder blockDecoder;
    protected final IndexDictionary.BrowserSupplier dictionaryBrowserSupplier;

    protected UniformSplitTerms(IndexInput blockInput, FieldMetadata fieldMetadata, PostingsReaderBase postingsReader, BlockDecoder blockDecoder, IndexDictionary.BrowserSupplier dictionaryBrowserSupplier) {
        assert (fieldMetadata != null);
        assert (fieldMetadata.getFieldInfo() != null);
        assert (fieldMetadata.getLastTerm() != null);
        assert (dictionaryBrowserSupplier != null);
        this.blockInput = blockInput;
        this.fieldMetadata = fieldMetadata;
        this.postingsReader = postingsReader;
        this.blockDecoder = blockDecoder;
        this.dictionaryBrowserSupplier = dictionaryBrowserSupplier;
    }

    @Override
    public TermsEnum iterator() throws IOException {
        return new BlockReader(this.dictionaryBrowserSupplier, this.blockInput, this.postingsReader, this.fieldMetadata, this.blockDecoder);
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        this.checkIntersectAutomatonType(compiled);
        return new IntersectBlockReader(compiled, startTerm, this.dictionaryBrowserSupplier, this.blockInput, this.postingsReader, this.fieldMetadata, this.blockDecoder);
    }

    protected void checkIntersectAutomatonType(CompiledAutomaton automaton) {
        if (automaton.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
    }

    @Override
    public BytesRef getMax() {
        return this.fieldMetadata.getLastTerm();
    }

    @Override
    public long size() {
        return this.fieldMetadata.getNumTerms();
    }

    @Override
    public long getSumTotalTermFreq() {
        return this.fieldMetadata.getSumTotalTermFreq();
    }

    @Override
    public long getSumDocFreq() {
        return this.fieldMetadata.getSumDocFreq();
    }

    @Override
    public int getDocCount() {
        return this.fieldMetadata.getDocCount();
    }

    @Override
    public boolean hasFreqs() {
        return this.fieldMetadata.getFieldInfo().getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public boolean hasOffsets() {
        return this.fieldMetadata.getFieldInfo().getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public boolean hasPositions() {
        return this.fieldMetadata.getFieldInfo().getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public boolean hasPayloads() {
        return this.fieldMetadata.getFieldInfo().hasPayloads();
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsedWithoutDictionary() + this.getDictionaryRamBytesUsed();
    }

    public long ramBytesUsedWithoutDictionary() {
        return BASE_RAM_USAGE + this.fieldMetadata.ramBytesUsed();
    }

    public long getDictionaryRamBytesUsed() {
        return this.dictionaryBrowserSupplier.ramBytesUsed();
    }
}

