/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.SortField;

public final class SimpleBindings
extends Bindings {
    private final Map<String, Function<Bindings, DoubleValuesSource>> map = new HashMap<String, Function<Bindings, DoubleValuesSource>>();

    @Deprecated
    public void add(SortField sortField) {
        this.map.put(sortField.getField(), bindings -> this.fromSortField(sortField));
    }

    public void add(String name, DoubleValuesSource source) {
        this.map.put(name, bindings -> source);
    }

    public void add(String name, Expression expression) {
        this.map.put(name, expression::getDoubleValuesSource);
    }

    private DoubleValuesSource fromSortField(SortField field) {
        switch (field.getType()) {
            case INT: {
                return DoubleValuesSource.fromIntField(field.getField());
            }
            case LONG: {
                return DoubleValuesSource.fromLongField(field.getField());
            }
            case FLOAT: {
                return DoubleValuesSource.fromFloatField(field.getField());
            }
            case DOUBLE: {
                return DoubleValuesSource.fromDoubleField(field.getField());
            }
            case SCORE: {
                return DoubleValuesSource.SCORES;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleValuesSource getDoubleValuesSource(String name) {
        if (!this.map.containsKey(name)) {
            throw new IllegalArgumentException("Invalid reference '" + name + "'");
        }
        return this.map.get(name).apply(this);
    }

    public void validate() {
        for (Map.Entry<String, Function<Bindings, DoubleValuesSource>> origin : this.map.entrySet()) {
            origin.getValue().apply(new CycleDetectionBindings(origin.getKey()));
        }
    }

    private class CycleDetectionBindings
    extends Bindings {
        private final Set<String> seenFields = new LinkedHashSet<String>();

        CycleDetectionBindings(String current) {
            this.seenFields.add(current);
        }

        CycleDetectionBindings(Set<String> parents, String current) {
            this.seenFields.addAll(parents);
            this.seenFields.add(current);
        }

        @Override
        public DoubleValuesSource getDoubleValuesSource(String name) {
            if (this.seenFields.contains(name)) {
                throw new IllegalArgumentException("Recursion error: Cycle detected " + this.seenFields + "->" + name);
            }
            if (!SimpleBindings.this.map.containsKey(name)) {
                throw new IllegalArgumentException("Invalid reference '" + name + "'");
            }
            return (DoubleValuesSource)((Function)SimpleBindings.this.map.get(name)).apply(new CycleDetectionBindings(this.seenFields, name));
        }
    }
}

