/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

class DrillSidewaysScorer
extends BulkScorer {
    private final Collector drillDownCollector;
    private LeafCollector drillDownLeafCollector;
    private final DocsAndCost[] dims;
    private final Scorer baseScorer;
    private final DocIdSetIterator baseIterator;
    private final LeafReaderContext context;
    final boolean scoreSubDocsAtOnce;
    private static final int CHUNK = 2048;
    private static final int MASK = 2047;
    private int collectDocID = -1;
    private float collectScore;

    DrillSidewaysScorer(LeafReaderContext context, Scorer baseScorer, Collector drillDownCollector, DocsAndCost[] dims, boolean scoreSubDocsAtOnce) {
        this.dims = dims;
        this.context = context;
        this.baseScorer = baseScorer;
        this.baseIterator = baseScorer.iterator();
        this.drillDownCollector = drillDownCollector;
        this.scoreSubDocsAtOnce = scoreSubDocsAtOnce;
    }

    @Override
    public long cost() {
        return this.baseIterator.cost();
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int maxDoc) throws IOException {
        if (min != 0) {
            throw new IllegalArgumentException("min must be 0, got " + min);
        }
        if (maxDoc != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maxDoc must be Integer.MAX_VALUE");
        }
        this.drillDownLeafCollector = this.drillDownCollector != null ? this.drillDownCollector.getLeafCollector(this.context) : null;
        for (DocsAndCost dim : this.dims) {
            dim.sidewaysLeafCollector = dim.sidewaysCollector.getLeafCollector(this.context);
        }
        long baseQueryCost = this.baseIterator.cost();
        int numDims = this.dims.length;
        long drillDownCost = 0L;
        for (int dim = 0; dim < numDims; ++dim) {
            drillDownCost += this.dims[dim].approximation.cost();
        }
        long drillDownAdvancedCost = 0L;
        if (numDims > 1) {
            drillDownAdvancedCost = this.dims[1].approximation.cost();
        }
        this.baseIterator.nextDoc();
        for (DocsAndCost dim : this.dims) {
            dim.approximation.nextDoc();
        }
        if (this.scoreSubDocsAtOnce || baseQueryCost < drillDownCost / 10L) {
            this.doQueryFirstScoring(acceptDocs, collector, this.dims);
        } else if (numDims > 1 && drillDownAdvancedCost < baseQueryCost / 10L) {
            this.doDrillDownAdvanceScoring(acceptDocs, collector, this.dims);
        } else {
            this.doUnionScoring(acceptDocs, collector, this.dims);
        }
        return Integer.MAX_VALUE;
    }

    private void doQueryFirstScoring(Bits acceptDocs, LeafCollector collector, DocsAndCost[] dims) throws IOException {
        this.setScorer(collector, ScoreCachingWrappingScorer.wrap(this.baseScorer));
        int docID = this.baseScorer.docID();
        block0: while (docID != Integer.MAX_VALUE) {
            if (acceptDocs != null && !acceptDocs.get(docID)) {
                docID = this.baseIterator.nextDoc();
                continue;
            }
            LeafCollector failedCollector = null;
            for (DocsAndCost dim : dims) {
                if (dim.approximation.docID() < docID) {
                    dim.approximation.advance(docID);
                }
                boolean matches = false;
                if (dim.approximation.docID() == docID) {
                    matches = dim.twoPhase == null ? true : dim.twoPhase.matches();
                }
                if (matches) continue;
                if (failedCollector != null) {
                    docID = this.baseIterator.nextDoc();
                    continue block0;
                }
                failedCollector = dim.sidewaysLeafCollector;
            }
            this.collectDocID = docID;
            if (failedCollector == null) {
                this.collectHit(collector, dims);
            } else {
                this.collectNearMiss(failedCollector);
            }
            docID = this.baseIterator.nextDoc();
        }
    }

    private void doDrillDownAdvanceScoring(Bits acceptDocs, LeafCollector collector, DocsAndCost[] dims) throws IOException {
        this.setScorer(collector, new ScoreAndDoc());
        int maxDoc = this.context.reader().maxDoc();
        int numDims = dims.length;
        int[] filledSlots = new int[2048];
        int[] docIDs = new int[2048];
        float[] scores = new float[2048];
        int[] missingDims = new int[2048];
        int[] counts = new int[2048];
        docIDs[0] = -1;
        int nextChunkStart = 2048;
        FixedBitSet seen = new FixedBitSet(2048);
        while (true) {
            int slot;
            int slot2;
            DocsAndCost dc = dims[0];
            int docID = dc.approximation.docID();
            while (docID < nextChunkStart) {
                if ((acceptDocs == null || acceptDocs.get(docID)) && docIDs[slot2 = docID & 0x7FF] != docID && (dc.twoPhase == null || dc.twoPhase.matches())) {
                    seen.set(slot2);
                    docIDs[slot2] = docID;
                    missingDims[slot2] = 1;
                    counts[slot2] = 1;
                }
                docID = dc.approximation.nextDoc();
            }
            dc = dims[1];
            docID = dc.approximation.docID();
            while (docID < nextChunkStart) {
                if (acceptDocs == null || acceptDocs.get(docID) && (dc.twoPhase == null || dc.twoPhase.matches())) {
                    slot2 = docID & 0x7FF;
                    if (docIDs[slot2] != docID) {
                        seen.set(slot2);
                        docIDs[slot2] = docID;
                        missingDims[slot2] = 0;
                        counts[slot2] = 1;
                    } else if (missingDims[slot2] >= 1) {
                        missingDims[slot2] = 2;
                        counts[slot2] = 2;
                    } else {
                        counts[slot2] = 1;
                    }
                }
                docID = dc.approximation.nextDoc();
            }
            int filledCount = 0;
            for (int slot0 = 0; slot0 < 2048 && (slot0 = seen.nextSetBit(slot0)) != Integer.MAX_VALUE; ++slot0) {
                int ddDocID = docIDs[slot0];
                assert (ddDocID != -1);
                int baseDocID = this.baseIterator.docID();
                if (baseDocID < ddDocID) {
                    baseDocID = this.baseIterator.advance(ddDocID);
                }
                if (baseDocID == ddDocID) {
                    scores[slot0] = this.baseScorer.score();
                    filledSlots[filledCount++] = slot0;
                    int n = slot0;
                    counts[n] = counts[n] + 1;
                    continue;
                }
                docIDs[slot0] = -1;
            }
            seen.clear(0, 2048);
            if (filledCount == 0) {
                if (nextChunkStart >= maxDoc) break;
                nextChunkStart += 2048;
                continue;
            }
            for (int dim = 2; dim < numDims; ++dim) {
                dc = dims[dim];
                docID = dc.approximation.docID();
                while (docID < nextChunkStart) {
                    slot = docID & 0x7FF;
                    if (docIDs[slot] == docID && counts[slot] >= dim && (dc.twoPhase == null || dc.twoPhase.matches())) {
                        if (missingDims[slot] >= dim) {
                            missingDims[slot] = dim + 1;
                            counts[slot] = dim + 2;
                        } else {
                            counts[slot] = dim + 1;
                        }
                    }
                    docID = dc.approximation.nextDoc();
                }
            }
            for (int i = 0; i < filledCount; ++i) {
                slot = filledSlots[i];
                this.collectDocID = docIDs[slot];
                this.collectScore = scores[slot];
                if (counts[slot] == 1 + numDims) {
                    this.collectHit(collector, dims);
                    continue;
                }
                if (counts[slot] != numDims) continue;
                this.collectNearMiss(dims[missingDims[slot]].sidewaysLeafCollector);
            }
            if (nextChunkStart >= maxDoc) break;
            nextChunkStart += 2048;
        }
    }

    private void doUnionScoring(Bits acceptDocs, LeafCollector collector, DocsAndCost[] dims) throws IOException {
        this.setScorer(collector, new ScoreAndDoc());
        int maxDoc = this.context.reader().maxDoc();
        int numDims = dims.length;
        int[] filledSlots = new int[2048];
        int[] docIDs = new int[2048];
        float[] scores = new float[2048];
        int[] missingDims = new int[2048];
        int[] counts = new int[2048];
        docIDs[0] = -1;
        int nextChunkStart = 2048;
        while (true) {
            int filledCount = 0;
            int docID = this.baseIterator.docID();
            while (docID < nextChunkStart) {
                if (acceptDocs == null || acceptDocs.get(docID)) {
                    int slot = docID & 0x7FF;
                    assert (docIDs[slot] != docID) : "slot=" + slot + " docID=" + docID;
                    docIDs[slot] = docID;
                    scores[slot] = this.baseScorer.score();
                    filledSlots[filledCount++] = slot;
                    missingDims[slot] = 0;
                    counts[slot] = 1;
                }
                docID = this.baseIterator.nextDoc();
            }
            if (filledCount == 0) {
                if (nextChunkStart >= maxDoc) break;
                nextChunkStart += 2048;
                continue;
            }
            DocsAndCost dc = dims[0];
            docID = dc.approximation.docID();
            while (docID < nextChunkStart) {
                int slot = docID & 0x7FF;
                if (docIDs[slot] == docID && (dc.twoPhase == null || dc.twoPhase.matches())) {
                    missingDims[slot] = 1;
                    counts[slot] = 2;
                }
                docID = dc.approximation.nextDoc();
            }
            for (int dim = 1; dim < numDims; ++dim) {
                DocsAndCost dc2 = dims[dim];
                docID = dc2.approximation.docID();
                while (docID < nextChunkStart) {
                    int slot = docID & 0x7FF;
                    if (docIDs[slot] == docID && counts[slot] >= dim && (dc2.twoPhase == null || dc2.twoPhase.matches())) {
                        if (missingDims[slot] >= dim) {
                            missingDims[slot] = dim + 1;
                            counts[slot] = dim + 2;
                        } else {
                            counts[slot] = dim + 1;
                        }
                    }
                    docID = dc2.approximation.nextDoc();
                }
            }
            for (int i = 0; i < filledCount; ++i) {
                int slot = filledSlots[i];
                this.collectDocID = docIDs[slot];
                this.collectScore = scores[slot];
                if (counts[slot] == 1 + numDims) {
                    this.collectHit(collector, dims);
                    continue;
                }
                if (counts[slot] != numDims) continue;
                this.collectNearMiss(dims[missingDims[slot]].sidewaysLeafCollector);
            }
            if (nextChunkStart >= maxDoc) break;
            nextChunkStart += 2048;
        }
    }

    private void collectHit(LeafCollector collector, DocsAndCost[] dims) throws IOException {
        collector.collect(this.collectDocID);
        if (this.drillDownCollector != null) {
            this.drillDownLeafCollector.collect(this.collectDocID);
        }
        for (DocsAndCost dim : dims) {
            dim.sidewaysLeafCollector.collect(this.collectDocID);
        }
    }

    private void collectNearMiss(LeafCollector sidewaysCollector) throws IOException {
        sidewaysCollector.collect(this.collectDocID);
    }

    private void setScorer(LeafCollector mainCollector, Scorable scorer) throws IOException {
        mainCollector.setScorer(scorer);
        if (this.drillDownLeafCollector != null) {
            this.drillDownLeafCollector.setScorer(scorer);
        }
        for (DocsAndCost dim : this.dims) {
            dim.sidewaysLeafCollector.setScorer(scorer);
        }
    }

    static class DocsAndCost {
        final DocIdSetIterator approximation;
        final TwoPhaseIterator twoPhase;
        final Collector sidewaysCollector;
        LeafCollector sidewaysLeafCollector;

        DocsAndCost(Scorer scorer, Collector sidewaysCollector) {
            TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
            if (twoPhase == null) {
                this.approximation = scorer.iterator();
                this.twoPhase = null;
            } else {
                this.approximation = twoPhase.approximation();
                this.twoPhase = twoPhase;
            }
            this.sidewaysCollector = sidewaysCollector;
        }
    }

    private final class ScoreAndDoc
    extends Scorable {
        private ScoreAndDoc() {
        }

        @Override
        public int docID() {
            return DrillSidewaysScorer.this.collectDocID;
        }

        @Override
        public float score() {
            return DrillSidewaysScorer.this.collectScore;
        }

        @Override
        public Collection<Scorable.ChildScorable> getChildren() {
            return Collections.singletonList(new Scorable.ChildScorable(DrillSidewaysScorer.this.baseScorer, "MUST"));
        }
    }
}

