/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.DocValuesOrdinalsReader;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FilterBinaryDocValues;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class OrdinalMappingLeafReader
extends FilterLeafReader {
    private final int[] ordinalMap;
    private final InnerFacetsConfig facetsConfig;
    private final Set<String> facetFields;

    public OrdinalMappingLeafReader(LeafReader in, int[] ordinalMap, FacetsConfig srcConfig) {
        super(in);
        this.ordinalMap = ordinalMap;
        this.facetsConfig = new InnerFacetsConfig();
        this.facetFields = new HashSet<String>();
        for (FacetsConfig.DimConfig dc : srcConfig.getDimConfigs().values()) {
            this.facetFields.add(dc.indexFieldName);
        }
        this.facetFields.add(FacetsConfig.DEFAULT_DIM_CONFIG.indexFieldName);
    }

    protected BytesRef encode(IntsRef ordinals) {
        return this.facetsConfig.dedupAndEncode(ordinals);
    }

    protected OrdinalsReader getOrdinalsReader(String field) {
        return new DocValuesOrdinalsReader(field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        if (this.facetFields.contains(field)) {
            OrdinalsReader ordsReader = this.getOrdinalsReader(field);
            return new OrdinalMappingBinaryDocValues(ordsReader.getReader(this.in.getContext()), this.in.getBinaryDocValues(field));
        }
        return this.in.getBinaryDocValues(field);
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private class OrdinalMappingBinaryDocValues
    extends FilterBinaryDocValues {
        private final IntsRef ordinals;
        private final OrdinalsReader.OrdinalsSegmentReader ordsReader;

        OrdinalMappingBinaryDocValues(OrdinalsReader.OrdinalsSegmentReader ordsReader, BinaryDocValues in) throws IOException {
            super(in);
            this.ordinals = new IntsRef(32);
            this.ordsReader = ordsReader;
        }

        @Override
        public BytesRef binaryValue() {
            try {
                this.ordsReader.get(this.docID(), this.ordinals);
                for (int i = 0; i < this.ordinals.length; ++i) {
                    this.ordinals.ints[i] = OrdinalMappingLeafReader.this.ordinalMap[this.ordinals.ints[i]];
                }
                return OrdinalMappingLeafReader.this.encode(this.ordinals);
            }
            catch (IOException e) {
                throw new RuntimeException("error reading category ordinals for doc " + this.docID(), e);
            }
        }
    }

    private static class InnerFacetsConfig
    extends FacetsConfig {
        InnerFacetsConfig() {
        }

        @Override
        public BytesRef dedupAndEncode(IntsRef ordinals) {
            return super.dedupAndEncode(ordinals);
        }
    }
}

