/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.solr.analysis.SolrAnalyzer;

public final class TokenizerChain
extends SolrAnalyzer {
    private static final CharFilterFactory[] EMPTY_CHAR_FITLERS = new CharFilterFactory[0];
    private static final TokenFilterFactory[] EMPTY_TOKEN_FITLERS = new TokenFilterFactory[0];
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] filters;

    public TokenizerChain(TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this(null, tokenizer, filters);
    }

    public TokenizerChain(CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        charFilters = null == charFilters ? EMPTY_CHAR_FITLERS : charFilters;
        TokenFilterFactory[] tokenFilterFactoryArray = filters = null == filters ? EMPTY_TOKEN_FITLERS : filters;
        if (null == tokenizer) {
            throw new NullPointerException("TokenizerFactory must not be null");
        }
        this.charFilters = charFilters;
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    public CharFilterFactory[] getCharFilterFactories() {
        return this.charFilters;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizer;
    }

    public TokenFilterFactory[] getTokenFilterFactories() {
        return this.filters;
    }

    @Override
    public Reader initReader(String fieldName, Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            Reader cs = reader;
            for (CharFilterFactory charFilter : this.charFilters) {
                cs = charFilter.create(cs);
            }
            reader = cs;
        }
        return reader;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tk;
        Tokenizer ts = tk = this.tokenizer.create();
        for (TokenFilterFactory filter : this.filters) {
            ts = filter.create((TokenStream)ts);
        }
        return new Analyzer.TokenStreamComponents(tk, (TokenStream)ts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TokenizerChain(");
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory);
            sb.append(", ");
        }
        sb.append(this.tokenizer);
        for (CharFilterFactory charFilterFactory : this.filters) {
            sb.append(", ");
            sb.append(charFilterFactory);
        }
        sb.append(')');
        return sb.toString();
    }
}

