/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class DistributedMap {
    protected final String dir;
    protected SolrZkClient zookeeper;
    protected final String prefix = "mn-";

    public DistributedMap(SolrZkClient zookeeper, String dir) {
        this.dir = dir;
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zookeeper.getZkClientTimeout());
        try {
            cmdExecutor.ensureExists(dir, zookeeper);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.zookeeper = zookeeper;
    }

    public void put(String trackingId, byte[] data) throws KeeperException, InterruptedException {
        this.zookeeper.makePath(this.dir + "/" + "mn-" + trackingId, data, CreateMode.PERSISTENT, null, false, true);
    }

    public byte[] get(String trackingId) throws KeeperException, InterruptedException {
        return this.zookeeper.getData(this.dir + "/" + "mn-" + trackingId, null, null, true);
    }

    public boolean contains(String trackingId) throws KeeperException, InterruptedException {
        return this.zookeeper.exists(this.dir + "/" + "mn-" + trackingId, true);
    }

    public int size() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zookeeper.getData(this.dir, null, stat, true);
        return stat.getNumChildren();
    }

    public boolean remove(String trackingId) throws KeeperException, InterruptedException {
        try {
            this.zookeeper.delete(this.dir + "/" + "mn-" + trackingId, -1, true);
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        return true;
    }

    public void clear() throws KeeperException, InterruptedException {
        List<String> childNames = this.zookeeper.getChildren(this.dir, null, true);
        for (String childName : childNames) {
            this.zookeeper.delete(this.dir + "/" + childName, -1, true);
        }
    }
}

