/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ZkStateReader zkStateReader;

    public ClusterStateMutator(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
    }

    public ZkWriteCommand createCollection(ClusterState clusterState, ZkNodeProps message) {
        String cName = message.getStr("name");
        log.info("building a new cName: " + cName);
        if (clusterState.hasCollection(cName)) {
            log.warn("Collection {} already exists. exit", (Object)cName);
            return ZkStateWriter.NO_OP;
        }
        ArrayList<String> shards = new ArrayList<String>();
        if ("implicit".equals(message.getStr("router.name", "compositeId"))) {
            ClusterStateMutator.getShardNames(shards, message.getStr("shards", "compositeId"));
        } else {
            int numShards = message.getInt("numShards", -1);
            if (numShards < 1) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "numShards is a required parameter for 'compositeId' router");
            }
            ClusterStateMutator.getShardNames(numShards, shards);
        }
        Map<String, Object> routerSpec = DocRouter.getRouterSpec(message);
        String routerName = routerSpec.get("name") == null ? "compositeId" : (String)routerSpec.get("name");
        DocRouter router = DocRouter.getDocRouter(routerName);
        List<DocRouter.Range> ranges = router.partitionRange(shards.size(), router.fullRange());
        LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
        for (int i = 0; i < shards.size(); ++i) {
            String sliceName = shards.get(i);
            LinkedHashMap<String, Object> sliceProps = new LinkedHashMap<String, Object>(1);
            sliceProps.put("range", ranges == null ? null : ranges.get(i));
            newSlices.put(sliceName, new Slice(sliceName, null, sliceProps));
        }
        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : OverseerCollectionMessageHandler.COLL_PROPS.entrySet()) {
            Object val = message.get(e.getKey());
            if (val == null) {
                val = OverseerCollectionMessageHandler.COLL_PROPS.get(e.getKey());
            }
            if (val == null) continue;
            collectionProps.put(e.getKey(), val);
        }
        collectionProps.put("router", routerSpec);
        if (message.getStr("fromApi") == null) {
            collectionProps.put("autoCreated", "true");
        }
        String znode = message.getInt("stateFormat", 1) == 1 ? null : ZkStateReader.getCollectionPath(cName);
        DocCollection newCollection = new DocCollection(cName, newSlices, collectionProps, router, -1, znode);
        return new ZkWriteCommand(cName, newCollection);
    }

    public ZkWriteCommand deleteCollection(ClusterState clusterState, ZkNodeProps message) {
        String collection = message.getStr("name");
        if (!CollectionMutator.checkKeyExistence(message, "name")) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollectionOrNull(collection);
        if (coll == null) {
            return ZkStateWriter.NO_OP;
        }
        return new ZkWriteCommand(coll.getName(), null);
    }

    public static ClusterState newState(ClusterState state, String name, DocCollection collection) {
        ClusterState newClusterState = null;
        newClusterState = collection == null ? state.copyWith(name, null) : state.copyWith(name, collection);
        return newClusterState;
    }

    public static void getShardNames(Integer numShards, List<String> shardNames) {
        if (numShards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param");
        }
        for (int i = 0; i < numShards; ++i) {
            String sliceName = "shard" + (i + 1);
            shardNames.add(sliceName);
        }
    }

    public static void getShardNames(List<String> shardNames, String shards) {
        if (shards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
        for (String s : shards.split(",")) {
            if (s == null || s.trim().isEmpty()) continue;
            shardNames.add(s.trim());
        }
        if (shardNames.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
    }

    public static String getAssignedId(ClusterState state, String nodeName, ZkNodeProps coreState) {
        Collection<Slice> slices = state.getSlices(coreState.getStr("collection"));
        if (slices != null) {
            for (Slice slice : slices) {
                if (slice.getReplicasMap().get(nodeName) == null) continue;
                return slice.getName();
            }
        }
        return null;
    }

    public static String getAssignedCoreNodeName(ClusterState state, ZkNodeProps message) {
        Collection<Slice> slices = state.getSlices(message.getStr("collection"));
        if (slices != null) {
            for (Slice slice : slices) {
                for (Replica replica : slice.getReplicas()) {
                    String nodeName = replica.getStr("node_name");
                    String core = replica.getStr("core");
                    String msgNodeName = message.getStr("node_name");
                    String msgCore = message.getStr("core");
                    if (!nodeName.equals(msgNodeName) || !core.equals(msgCore)) continue;
                    return replica.getName();
                }
            }
        }
        return null;
    }

    public ZkWriteCommand migrateStateFormat(ClusterState clusterState, ZkNodeProps message) {
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkKeyExistence(message, "collection")) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollectionOrNull(collection);
        if (coll == null || coll.getStateFormat() == 2) {
            return ZkStateWriter.NO_OP;
        }
        return new ZkWriteCommand(coll.getName(), new DocCollection(coll.getName(), coll.getSlicesMap(), coll.getProperties(), coll.getRouter(), 0, ZkStateReader.getCollectionPath(collection)));
    }
}

