/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ByteUtils;
import org.apache.solr.common.util.StrUtils;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Pattern ARRAY_ELEMENT_INDEX = Pattern.compile("(\\S*?)\\[(\\d+)\\]");

    public static Map getDeepCopy(Map map, int maxDepth) {
        return Utils.getDeepCopy(map, maxDepth, true);
    }

    public static Map getDeepCopy(Map map, int maxDepth, boolean mutable) {
        if (map == null) {
            return null;
        }
        if (maxDepth < 1) {
            return map;
        }
        LinkedHashMap copy = new LinkedHashMap();
        for (Map.Entry o : map.entrySet()) {
            Map.Entry e = o;
            Object v = e.getValue();
            if (v instanceof Map) {
                v = Utils.getDeepCopy((Map)v, maxDepth - 1, mutable);
            } else if (v instanceof Collection) {
                v = Utils.getDeepCopy((Collection)v, maxDepth - 1, mutable);
            }
            copy.put(e.getKey(), v);
        }
        return mutable ? copy : Collections.unmodifiableMap(copy);
    }

    public static Collection getDeepCopy(Collection c, int maxDepth, boolean mutable) {
        if (c == null || maxDepth < 1) {
            return c;
        }
        AbstractCollection result = c instanceof Set ? new HashSet() : new ArrayList();
        for (Object o : c) {
            if (o instanceof Map) {
                o = Utils.getDeepCopy((Map)o, maxDepth - 1, mutable);
            }
            result.add(o);
        }
        return mutable ? result : (result instanceof Set ? Collections.unmodifiableSet((Set)((Object)result)) : Collections.unmodifiableList((List)((Object)result)));
    }

    public static byte[] toJSON(Object o) {
        if (o == null) {
            return new byte[0];
        }
        CharArr out = new CharArr();
        new JSONWriter(out, 2).write(o);
        return Utils.toUTF8(out);
    }

    public static String toJSONString(Object o) {
        return new String(Utils.toJSON(o), StandardCharsets.UTF_8);
    }

    public static byte[] toUTF8(CharArr out) {
        byte[] arr = new byte[out.size() * 3];
        int nBytes = ByteUtils.UTF16toUTF8((CharSequence)out, 0, out.size(), arr, 0);
        return Arrays.copyOf(arr, nBytes);
    }

    public static Object fromJSON(byte[] utf8) {
        CharArr chars = new CharArr();
        ByteUtils.UTF8toUTF16(utf8, 0, utf8.length, chars);
        JSONParser parser = new JSONParser(chars.getArray(), chars.getStart(), chars.length());
        try {
            return ObjectBuilder.getVal((JSONParser)parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> makeMap(Object ... keyVals) {
        if ((keyVals.length & 1) != 0) {
            throw new IllegalArgumentException("arguments should be key,value");
        }
        LinkedHashMap<String, Object> propMap = new LinkedHashMap<String, Object>(keyVals.length >> 1);
        for (int i = 0; i < keyVals.length; i += 2) {
            propMap.put(keyVals[i].toString(), keyVals[i + 1]);
        }
        return propMap;
    }

    public static Object fromJSONString(String json) {
        try {
            return new ObjectBuilder(new JSONParser((Reader)new StringReader(json))).getObject();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error", (Throwable)e);
        }
    }

    public static Object getObjectByPath(Map root, boolean onlyPrimitive, String hierarchy) {
        return Utils.getObjectByPath(root, onlyPrimitive, StrUtils.splitSmart(hierarchy, '/'));
    }

    public static Object getObjectByPath(Map root, boolean onlyPrimitive, List<String> hierarchy) {
        Map obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            List l;
            Object o;
            Matcher matcher;
            int idx = -1;
            String s = hierarchy.get(i);
            if (s.endsWith("]") && (matcher = ARRAY_ELEMENT_INDEX.matcher(s)).find()) {
                s = matcher.group(1);
                idx = Integer.parseInt(matcher.group(2));
            }
            if (i < hierarchy.size() - 1) {
                o = obj.get(s);
                if (o == null) {
                    return null;
                }
                if (idx > -1) {
                    l = (List)o;
                    Object v0 = (o = idx < l.size() ? l.get(idx) : null);
                }
                if (!(o instanceof Map)) {
                    return null;
                }
            } else {
                Object val = obj.get(s);
                if (idx > -1) {
                    l = (List)val;
                    Object v1 = (val = idx < l.size() ? l.get(idx) : null);
                }
                if (onlyPrimitive && val instanceof Map) {
                    return null;
                }
                return val;
            }
            obj = (Map)o;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consumeFully(HttpEntity entity) {
        if (entity != null) {
            try {
                Utils.readFully(entity.getContent());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
    }

    private static void readFully(InputStream is) throws IOException {
        is.skip(is.available());
        while (is.read() != -1) {
        }
    }
}

