/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;

public class CoreSorter {
    Map<String, CountsForEachShard> shardsVsReplicaCounts = new LinkedHashMap<String, CountsForEachShard>();
    CoreContainer cc;
    private static final CountsForEachShard zero = new CountsForEachShard(0, 0, 0);
    public static final Comparator<CountsForEachShard> countsComparator = new Comparator<CountsForEachShard>(){

        @Override
        public int compare(CountsForEachShard c1, CountsForEachShard c2) {
            if (c1 == null) {
                c1 = zero;
            }
            if (c2 == null) {
                c2 = zero;
            }
            if (c1.totalReplicasInDownNodes < c2.totalReplicasInDownNodes && c1.totalReplicasInLiveNodes > 0) {
                return -1;
            }
            if (c2.totalReplicasInDownNodes < c1.totalReplicasInDownNodes && c2.totalReplicasInLiveNodes > 0) {
                return 1;
            }
            if (c1.totalReplicasInLiveNodes > c2.totalReplicasInLiveNodes) {
                return -1;
            }
            if (c2.totalReplicasInLiveNodes > c1.totalReplicasInLiveNodes) {
                return 1;
            }
            if (c1.myReplicas < c2.myReplicas) {
                return -1;
            }
            if (c2.myReplicas < c1.myReplicas) {
                return 1;
            }
            return 0;
        }
    };
    public Comparator<CoreDescriptor> descComp = new Comparator<CoreDescriptor>(){

        @Override
        public int compare(CoreDescriptor cd1, CoreDescriptor cd2) {
            return CoreSorter.this.doCompare(cd1, cd2);
        }
    };

    public CoreSorter init(CoreContainer cc) {
        this.cc = cc;
        if (cc == null || !cc.isZooKeeperAware()) {
            return this;
        }
        String myNodeName = this.getNodeName();
        ClusterState state = cc.getZkController().getClusterState();
        for (CloudDescriptor cloudDescriptor : this.getCloudDescriptors()) {
            String coll = cloudDescriptor.getCollectionName();
            String sliceName = CoreSorter.getShardName(cloudDescriptor);
            if (this.shardsVsReplicaCounts.containsKey(sliceName)) continue;
            CountsForEachShard c = new CountsForEachShard(0, 0, 0);
            for (Replica replica : this.getReplicas(state, coll, cloudDescriptor.getShardId())) {
                if (replica.getNodeName().equals(myNodeName)) {
                    ++c.myReplicas;
                    continue;
                }
                Set<String> liveNodes = state.getLiveNodes();
                if (liveNodes.contains(replica.getNodeName())) {
                    ++c.totalReplicasInLiveNodes;
                    continue;
                }
                ++c.totalReplicasInDownNodes;
            }
            this.shardsVsReplicaCounts.put(sliceName, c);
        }
        return this;
    }

    public int doCompare(CoreDescriptor cd1, CoreDescriptor cd2) {
        CountsForEachShard c2;
        String s1 = CoreSorter.getShardName(cd1.getCloudDescriptor());
        String s2 = CoreSorter.getShardName(cd2.getCloudDescriptor());
        if (s1 == null || s2 == null) {
            return cd1.getName().compareTo(cd2.getName());
        }
        CountsForEachShard c1 = this.shardsVsReplicaCounts.get(s1);
        int result = countsComparator.compare(c1, c2 = this.shardsVsReplicaCounts.get(s2));
        return result == 0 ? s1.compareTo(s2) : result;
    }

    static String getShardName(CloudDescriptor cd) {
        return cd == null ? null : cd.getCollectionName() + "_" + cd.getShardId();
    }

    String getNodeName() {
        return this.cc.getNodeConfig().getNodeName();
    }

    Collection<Replica> getReplicas(ClusterState cs, String coll, String slice) {
        DocCollection c = cs.getCollectionOrNull(coll);
        if (c == null) {
            return Collections.emptyList();
        }
        Slice s = c.getSlice(slice);
        if (s == null) {
            return Collections.emptyList();
        }
        return s.getReplicas();
    }

    Collection<CloudDescriptor> getCloudDescriptors() {
        Collection<SolrCore> cores = this.cc.getCores();
        ArrayList<CloudDescriptor> ret = new ArrayList<CloudDescriptor>(cores.size());
        for (SolrCore sc : cores) {
            ret.add(sc.getCoreDescriptor().getCloudDescriptor());
        }
        return ret;
    }

    static class CountsForEachShard {
        public int totalReplicasInDownNodes = 0;
        public int myReplicas = 0;
        public int totalReplicasInLiveNodes = 0;

        public CountsForEachShard(int totalReplicasInDownNodes, int totalReplicasInLiveNodes, int myReplicas) {
            this.totalReplicasInDownNodes = totalReplicasInDownNodes;
            this.myReplicas = myReplicas;
            this.totalReplicasInLiveNodes = totalReplicasInLiveNodes;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CountsForEachShard) {
                CountsForEachShard that = (CountsForEachShard)obj;
                return that.totalReplicasInDownNodes == this.totalReplicasInDownNodes && that.myReplicas == this.myReplicas;
            }
            return false;
        }

        public String toString() {
            return "down : " + this.totalReplicasInDownNodes + " , up :  " + this.totalReplicasInLiveNodes + " my : " + this.myReplicas;
        }
    }
}

