/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.StandardDirectoryFactory;

public class NRTCachingDirectoryFactory
extends StandardDirectoryFactory {
    public static final int DEFAULT_MAX_MERGE_SIZE_MB = 4;
    private double maxMergeSizeMB = 4.0;
    public static final int DEFAULT_MAX_CACHED_MB = 48;
    private double maxCachedMB = 48.0;

    @Override
    public void init(NamedList args) {
        super.init(args);
        SolrParams params = SolrParams.toSolrParams(args);
        this.maxMergeSizeMB = params.getDouble("maxMergeSizeMB", 4.0);
        if (this.maxMergeSizeMB <= 0.0) {
            throw new IllegalArgumentException("maxMergeSizeMB must be greater than 0");
        }
        this.maxCachedMB = params.getDouble("maxCachedMB", 48.0);
        if (this.maxCachedMB <= 0.0) {
            throw new IllegalArgumentException("maxCachedMB must be greater than 0");
        }
    }

    @Override
    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        return new NRTCachingDirectory((Directory)FSDirectory.open((Path)new File(path).toPath(), (LockFactory)lockFactory), this.maxMergeSizeMB, this.maxCachedMB);
    }

    @Override
    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }
}

