/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.Version;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigOverlay;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.InitParams;
import org.apache.solr.core.MapSerializable;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestParams;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.FastLRUCache;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.DOMUtil;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SolrConfig
extends Config
implements MapSerializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_CONF_FILE = "solrconfig.xml";
    private RequestParams requestParams;
    private int multipartUploadLimitKB;
    private int formUploadLimitKB;
    private boolean enableRemoteStreams;
    private boolean handleSelect;
    private boolean addHttpRequestToContext;
    private final SolrRequestParsers solrRequestParsers;
    public static final List<SolrPluginInfo> plugins = ImmutableList.builder().add((Object)new SolrPluginInfo((Class)SolrRequestHandler.class, "requestHandler", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK, PluginOpts.LAZY})).add((Object)new SolrPluginInfo((Class)QParserPlugin.class, "queryParser", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK})).add((Object)new SolrPluginInfo((Class)QueryResponseWriter.class, "queryResponseWriter", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK, PluginOpts.LAZY})).add((Object)new SolrPluginInfo((Class)ValueSourceParser.class, "valueSourceParser", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK})).add((Object)new SolrPluginInfo((Class)TransformerFactory.class, "transformer", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK})).add((Object)new SolrPluginInfo((Class)SearchComponent.class, "searchComponent", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK})).add((Object)new SolrPluginInfo((Class)UpdateRequestProcessorFactory.class, "updateProcessor", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK})).add((Object)new SolrPluginInfo((Class)QueryConverter.class, "queryConverter", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS})).add((Object)new SolrPluginInfo((Class)PluginBag.RuntimeLib.class, "runtimeLib", new PluginOpts[]{PluginOpts.REQUIRE_NAME, PluginOpts.MULTI_OK})).add((Object)new SolrPluginInfo((Class)InitParams.class, "initParams", new PluginOpts[]{PluginOpts.MULTI_OK, PluginOpts.REQUIRE_NAME_IN_OVERLAY})).add((Object)new SolrPluginInfo((Class)SolrEventListener.class, "//listener", new PluginOpts[]{PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK, PluginOpts.REQUIRE_NAME_IN_OVERLAY})).add((Object)new SolrPluginInfo((Class)DirectoryFactory.class, "directoryFactory", new PluginOpts[]{PluginOpts.REQUIRE_CLASS})).add((Object)new SolrPluginInfo((Class)IndexDeletionPolicy.class, "indexConfig/deletionPolicy", new PluginOpts[]{PluginOpts.REQUIRE_CLASS})).add((Object)new SolrPluginInfo((Class)CodecFactory.class, "codecFactory", new PluginOpts[]{PluginOpts.REQUIRE_CLASS})).add((Object)new SolrPluginInfo((Class)IndexReaderFactory.class, "indexReaderFactory", new PluginOpts[]{PluginOpts.REQUIRE_CLASS})).add((Object)new SolrPluginInfo((Class)UpdateRequestProcessorChain.class, "updateRequestProcessorChain", new PluginOpts[]{PluginOpts.MULTI_OK})).add((Object)new SolrPluginInfo((Class)UpdateLog.class, "updateHandler/updateLog", new PluginOpts[0])).add((Object)new SolrPluginInfo((Class)IndexSchemaFactory.class, "schemaFactory", new PluginOpts[]{PluginOpts.REQUIRE_CLASS})).add((Object)new SolrPluginInfo((Class)RestManager.class, "restManager", new PluginOpts[0])).add((Object)new SolrPluginInfo((Class)StatsCache.class, "statsCache", new PluginOpts[]{PluginOpts.REQUIRE_CLASS})).build();
    public static final Map<String, SolrPluginInfo> classVsSolrPluginInfo;
    private Map<String, InitParams> initParams = Collections.emptyMap();
    public final int booleanQueryMaxClauseCount;
    public final CacheConfig filterCacheConfig;
    public final CacheConfig queryResultCacheConfig;
    public final CacheConfig documentCacheConfig;
    public final CacheConfig fieldValueCacheConfig;
    public final CacheConfig[] userCacheConfigs;
    public final boolean useFilterForSortedQuery;
    public final int queryResultWindowSize;
    public final int queryResultMaxDocsCached;
    public final boolean enableLazyFieldLoading;
    public final float hashSetInverseLoadFactor;
    public final int hashDocSetMaxSize;
    @Deprecated
    public final SolrIndexConfig defaultIndexConfig;
    @Deprecated
    public final SolrIndexConfig mainIndexConfig;
    public final SolrIndexConfig indexConfig;
    protected UpdateHandlerInfo updateHandlerInfo;
    private Map<String, List<PluginInfo>> pluginStore = new LinkedHashMap<String, List<PluginInfo>>();
    public final int maxWarmingSearchers;
    public final boolean useColdSearcher;
    public final Version luceneMatchVersion;
    protected String dataDir;
    public final int slowQueryThresholdMillis;
    public final JmxConfiguration jmxConfig;
    private final HttpCachingConfig httpCachingConfig;
    private ConfigOverlay overlay;

    public SolrConfig() throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, DEFAULT_CONF_FILE, (InputSource)null);
    }

    public SolrConfig(String name) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, (InputSource)null);
    }

    public SolrConfig(String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, is);
    }

    public SolrConfig(Path instanceDir, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        this(new SolrResourceLoader(instanceDir), name, is);
    }

    public static SolrConfig readFromResourceLoader(SolrResourceLoader loader, String name) {
        try {
            return new SolrConfig(loader, name, null);
        }
        catch (Exception e) {
            String resource = loader instanceof ZkSolrResourceLoader ? name : Paths.get(loader.getConfigDir(), new String[0]).resolve(name).toString();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading solr config from " + resource, (Throwable)e);
        }
    }

    public SolrConfig(SolrResourceLoader loader, String name, InputSource is) throws ParserConfigurationException, IOException, SAXException {
        super(loader, name, is, "/config/");
        String indexConfigPrefix;
        boolean hasNewIndexConfig;
        this.getOverlay();
        this.getRequestParams();
        this.initLibs();
        this.luceneMatchVersion = this.getLuceneVersion("luceneMatchVersion");
        boolean hasDeprecatedIndexConfig = this.getNode("indexDefaults", false) != null || this.getNode("mainIndex", false) != null;
        boolean bl = hasNewIndexConfig = this.getNode("indexConfig", false) != null;
        if (hasDeprecatedIndexConfig) {
            if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_0_0_ALPHA)) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "<indexDefaults> and <mainIndex> configuration sections are discontinued. Use <indexConfig> instead.");
            }
            if (hasNewIndexConfig) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Cannot specify both <indexDefaults>, <mainIndex> and <indexConfig> at the same time. Please use <indexConfig> only.");
            }
            log.warn("<indexDefaults> and <mainIndex> configuration sections are deprecated and will fail for luceneMatchVersion=LUCENE_4_0_0 and later. Please use <indexConfig> instead.");
            this.defaultIndexConfig = new SolrIndexConfig(this, "indexDefaults", null);
            this.mainIndexConfig = new SolrIndexConfig(this, "mainIndex", this.defaultIndexConfig);
            indexConfigPrefix = "mainIndex";
        } else {
            this.mainIndexConfig = null;
            this.defaultIndexConfig = null;
            indexConfigPrefix = "indexConfig";
        }
        SolrConfig.assertWarnOrFail("The <nrtMode> config has been discontinued and NRT mode is always used by Solr. This config will be removed in future versions.", this.getNode(indexConfigPrefix + "/nrtMode", false) == null, false);
        SolrConfig.assertWarnOrFail("Solr no longer supports forceful unlocking via the 'unlockOnStartup' option.  This is no longer necessary for the default lockType except in situations where it would be dangerous and should not be done.  For other lockTypes and/or directoryFactory options it may also be dangerous and users must resolve problematic locks manually.", null == this.getNode(indexConfigPrefix + "/unlockOnStartup", false), false);
        this.indexConfig = new SolrIndexConfig(this, "indexConfig", this.mainIndexConfig);
        this.booleanQueryMaxClauseCount = this.getInt("query/maxBooleanClauses", BooleanQuery.getMaxClauseCount());
        log.info("Using Lucene MatchVersion: " + this.luceneMatchVersion);
        if (this.get("query/boolTofilterOptimizer", null) != null) {
            log.warn("solrconfig.xml: <boolTofilterOptimizer> is currently not implemented and has no effect.");
        }
        if (this.get("query/HashDocSet", null) != null) {
            log.warn("solrconfig.xml: <HashDocSet> is deprecated and no longer recommended used.");
        }
        this.useFilterForSortedQuery = this.getBool("query/useFilterForSortedQuery", false);
        this.queryResultWindowSize = Math.max(1, this.getInt("query/queryResultWindowSize", 1));
        this.queryResultMaxDocsCached = this.getInt("query/queryResultMaxDocsCached", Integer.MAX_VALUE);
        this.enableLazyFieldLoading = this.getBool("query/enableLazyFieldLoading", false);
        this.filterCacheConfig = CacheConfig.getConfig(this, "query/filterCache");
        this.queryResultCacheConfig = CacheConfig.getConfig(this, "query/queryResultCache");
        this.documentCacheConfig = CacheConfig.getConfig(this, "query/documentCache");
        CacheConfig conf = CacheConfig.getConfig(this, "query/fieldValueCache");
        if (conf == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", "fieldValueCache");
            args.put("size", "10000");
            args.put("initialSize", "10");
            args.put("showItems", "-1");
            conf = new CacheConfig(FastLRUCache.class, args, null);
        }
        this.fieldValueCacheConfig = conf;
        this.useColdSearcher = this.getBool("query/useColdSearcher", false);
        this.dataDir = this.get("dataDir", null);
        if (this.dataDir != null && this.dataDir.length() == 0) {
            this.dataDir = null;
        }
        this.userCacheConfigs = CacheConfig.getMultipleConfigs(this, "query/cache");
        SolrIndexSearcher.initRegenerators(this);
        this.hashSetInverseLoadFactor = 1.0f / this.getFloat("//HashDocSet/@loadFactor", 0.75f);
        this.hashDocSetMaxSize = this.getInt("//HashDocSet/@maxSize", 3000);
        this.httpCachingConfig = new HttpCachingConfig(this);
        Node jmx = this.getNode("jmx", false);
        this.jmxConfig = jmx != null ? new JmxConfiguration(true, this.get("jmx/@agentId", null), this.get("jmx/@serviceUrl", null), this.get("jmx/@rootName", null)) : new JmxConfiguration(false, null, null, null);
        this.maxWarmingSearchers = this.getInt("query/maxWarmingSearchers", Integer.MAX_VALUE);
        this.slowQueryThresholdMillis = this.getInt("query/slowQueryThresholdMillis", -1);
        for (SolrPluginInfo plugin : plugins) {
            this.loadPluginInfo(plugin);
        }
        this.updateHandlerInfo = this.loadUpdatehandlerInfo();
        this.multipartUploadLimitKB = this.getInt("requestDispatcher/requestParsers/@multipartUploadLimitInKB", 2048);
        this.formUploadLimitKB = this.getInt("requestDispatcher/requestParsers/@formdataUploadLimitInKB", 2048);
        this.enableRemoteStreams = this.getBool("requestDispatcher/requestParsers/@enableRemoteStreaming", false);
        this.handleSelect = this.getBool("requestDispatcher/@handleSelect", true);
        this.addHttpRequestToContext = this.getBool("requestDispatcher/requestParsers/@addHttpRequestToContext", false);
        List<PluginInfo> argsInfos = this.getPluginInfos(InitParams.class.getName());
        if (argsInfos != null) {
            HashMap<String, InitParams> argsMap = new HashMap<String, InitParams>();
            for (PluginInfo p : argsInfos) {
                InitParams args = new InitParams(p);
                argsMap.put(args.name == null ? String.valueOf(args.hashCode()) : args.name, args);
            }
            this.initParams = Collections.unmodifiableMap(argsMap);
        }
        this.solrRequestParsers = new SolrRequestParsers(this);
        log.info("Loaded SolrConfig: " + name);
    }

    public static ConfigOverlay getConfigOverlay(SolrResourceLoader loader) {
        ConfigOverlay configOverlay;
        InputStream in = null;
        InputStreamReader isr = null;
        try {
            in = loader.openResource("configoverlay.json");
        }
        catch (IOException e) {
            ConfigOverlay configOverlay2 = new ConfigOverlay(Collections.EMPTY_MAP, -1);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly(in);
            return configOverlay2;
        }
        try {
            int version = 0;
            if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                version = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                log.info("config overlay loaded . version : {} ", (Object)version);
            }
            isr = new InputStreamReader(in, StandardCharsets.UTF_8);
            Map m = (Map)ObjectBuilder.getVal((JSONParser)new JSONParser((Reader)isr));
            configOverlay = new ConfigOverlay(m, version);
        }
        catch (Exception e) {
            try {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading config overlay", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(isr);
        IOUtils.closeQuietly(in);
        return configOverlay;
    }

    public Map<String, InitParams> getInitParams() {
        return this.initParams;
    }

    protected UpdateHandlerInfo loadUpdatehandlerInfo() {
        return new UpdateHandlerInfo(this.get("updateHandler/@class", null), this.getInt("updateHandler/autoCommit/maxDocs", -1), this.getInt("updateHandler/autoCommit/maxTime", -1), this.getBool("updateHandler/indexWriter/closeWaitsForMerges", true), this.getBool("updateHandler/autoCommit/openSearcher", true), this.getInt("updateHandler/autoSoftCommit/maxDocs", -1), this.getInt("updateHandler/autoSoftCommit/maxTime", -1), this.getBool("updateHandler/commitWithin/softCommit", true));
    }

    private void loadPluginInfo(SolrPluginInfo pluginInfo) {
        boolean requireClass;
        boolean requireName = pluginInfo.options.contains((Object)PluginOpts.REQUIRE_NAME);
        List<PluginInfo> result = this.readPluginInfos(pluginInfo.tag, requireName, requireClass = pluginInfo.options.contains((Object)PluginOpts.REQUIRE_CLASS));
        if (1 < result.size() && !pluginInfo.options.contains((Object)PluginOpts.MULTI_OK)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Found " + result.size() + " configuration sections when at most " + "1 is allowed matching expression: " + pluginInfo.getCleanTag());
        }
        if (!result.isEmpty()) {
            this.pluginStore.put(pluginInfo.clazz.getName(), result);
        }
    }

    public List<PluginInfo> readPluginInfos(String tag, boolean requireName, boolean requireClass) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        NodeList nodes = (NodeList)this.evaluate(tag, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            PluginInfo pluginInfo = new PluginInfo(nodes.item(i), "[solrconfig.xml] " + tag, requireName, requireClass);
            if (!pluginInfo.isEnabled()) continue;
            result.add(pluginInfo);
        }
        return result;
    }

    public SolrRequestParsers getRequestParsers() {
        return this.solrRequestParsers;
    }

    public HttpCachingConfig getHttpCachingConfig() {
        return this.httpCachingConfig;
    }

    public UpdateHandlerInfo getUpdateHandlerInfo() {
        return this.updateHandlerInfo;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public List<PluginInfo> getPluginInfos(String type) {
        Map<String, Map> infos;
        List<PluginInfo> result = this.pluginStore.get(type);
        SolrPluginInfo info = classVsSolrPluginInfo.get(type);
        if (info != null && (info.options.contains((Object)PluginOpts.REQUIRE_NAME) || info.options.contains((Object)PluginOpts.REQUIRE_NAME_IN_OVERLAY)) && !(infos = this.overlay.getNamedPlugins(info.getCleanTag())).isEmpty()) {
            LinkedHashMap<String, PluginInfo> map = new LinkedHashMap<String, PluginInfo>();
            if (result != null) {
                for (PluginInfo pluginInfo : result) {
                    String name = pluginInfo.name == null ? UUID.randomUUID().toString().toLowerCase(Locale.ROOT) : pluginInfo.name;
                    map.put(name, pluginInfo);
                }
            }
            for (Map.Entry entry : infos.entrySet()) {
                map.put((String)entry.getKey(), new PluginInfo(info.getCleanTag(), (Map)entry.getValue()));
            }
            result = new ArrayList(map.values());
        }
        return result == null ? Collections.emptyList() : result;
    }

    public PluginInfo getPluginInfo(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (1 == result.size()) {
            return result.get(0);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple plugins configured for type: " + type);
    }

    private void initLibs() {
        NodeList nodes = (NodeList)this.evaluate("lib", XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        log.info("Adding specified lib dirs to ClassLoader");
        SolrResourceLoader loader = this.getResourceLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Path dir;
            Node node = nodes.item(i);
            String baseDir = DOMUtil.getAttr(node, "dir");
            String path = DOMUtil.getAttr(node, "path");
            if (null != baseDir) {
                dir = loader.getInstancePath().resolve(baseDir);
                String regex = DOMUtil.getAttr(node, "regex");
                try {
                    if (regex == null) {
                        urls.addAll(SolrResourceLoader.getURLs(dir));
                        continue;
                    }
                    urls.addAll(SolrResourceLoader.getFilteredURLs(dir, regex));
                }
                catch (IOException e) {
                    log.warn("Couldn't add files from {} filtered by {} to classpath: {}", new Object[]{dir, regex, e.getMessage()});
                }
                continue;
            }
            if (null != path) {
                dir = loader.getInstancePath().resolve(path);
                try {
                    urls.add(dir.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    log.warn("Couldn't add file {} to classpath: {}", (Object)dir, (Object)e.getMessage());
                }
                continue;
            }
            throw new RuntimeException("lib: missing mandatory attributes: 'dir' or 'path'");
        }
        if (urls.size() > 0) {
            loader.addToClassLoader(urls);
            loader.reloadLuceneSPI();
        }
    }

    public int getMultipartUploadLimitKB() {
        return this.multipartUploadLimitKB;
    }

    public int getFormUploadLimitKB() {
        return this.formUploadLimitKB;
    }

    public boolean isHandleSelect() {
        return this.handleSelect;
    }

    public boolean isAddHttpRequestToContext() {
        return this.addHttpRequestToContext;
    }

    public boolean isEnableRemoteStreams() {
        return this.enableRemoteStreams;
    }

    @Override
    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    @Override
    public int getInt(String path, int def) {
        Object val = this.overlay.getXPathProperty(path);
        if (val != null) {
            return Integer.parseInt(val.toString());
        }
        return super.getInt(path, def);
    }

    @Override
    public boolean getBool(String path, boolean def) {
        Object val = this.overlay.getXPathProperty(path);
        if (val != null) {
            return Boolean.parseBoolean(val.toString());
        }
        return super.getBool(path, def);
    }

    @Override
    public String get(String path) {
        Object val = this.overlay.getXPathProperty(path, true);
        return val != null ? val.toString() : super.get(path);
    }

    @Override
    public String get(String path, String def) {
        Object val = this.overlay.getXPathProperty(path, true);
        return val != null ? val.toString() : super.get(path, def);
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.getZnodeVersion() > -1) {
            result.put("znodeVersion", this.getZnodeVersion());
        }
        result.put("luceneMatchVersion", this.luceneMatchVersion);
        result.put("updateHandler", this.getUpdateHandlerInfo().toMap());
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        result.put("query", m);
        m.put("useFilterForSortedQuery", this.useFilterForSortedQuery);
        m.put("queryResultWindowSize", this.queryResultWindowSize);
        m.put("queryResultMaxDocsCached", this.queryResultMaxDocsCached);
        m.put("enableLazyFieldLoading", this.enableLazyFieldLoading);
        m.put("maxBooleanClauses", this.booleanQueryMaxClauseCount);
        if (this.jmxConfig != null) {
            result.put("jmx", this.jmxConfig.toMap());
        }
        for (SolrPluginInfo plugin : plugins) {
            List<PluginInfo> infos = this.getPluginInfos(plugin.clazz.getName());
            if (infos == null || infos.isEmpty()) continue;
            String tag = plugin.getCleanTag();
            tag = tag.replace("/", "");
            if (plugin.options.contains((Object)PluginOpts.REQUIRE_NAME)) {
                LinkedHashMap<String, Map<String, Object>> items = new LinkedHashMap<String, Map<String, Object>>();
                for (PluginInfo pluginInfo : infos) {
                    items.put(pluginInfo.name, pluginInfo.toMap());
                }
                for (Map.Entry entry : this.overlay.getNamedPlugins(plugin.tag).entrySet()) {
                    items.put((String)entry.getKey(), (Map<String, Object>)entry.getValue());
                }
                result.put(tag, items);
                continue;
            }
            if (plugin.options.contains((Object)PluginOpts.MULTI_OK)) {
                ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
                for (PluginInfo pluginInfo : infos) {
                    l.add(pluginInfo.toMap());
                }
                result.put(tag, l);
                continue;
            }
            result.put(tag, infos.get(0).toMap());
        }
        this.addCacheConfig(m, this.filterCacheConfig, this.queryResultCacheConfig, this.documentCacheConfig, this.fieldValueCacheConfig);
        if (this.jmxConfig != null) {
            result.put("jmx", this.jmxConfig.toMap());
        }
        m = new LinkedHashMap();
        result.put("requestDispatcher", m);
        m.put("handleSelect", this.handleSelect);
        if (this.httpCachingConfig != null) {
            m.put("httpCaching", this.httpCachingConfig.toMap());
        }
        m.put("requestParsers", Utils.makeMap("multipartUploadLimitKB", this.multipartUploadLimitKB, "formUploadLimitKB", this.formUploadLimitKB, "addHttpRequestToContext", this.addHttpRequestToContext));
        if (this.indexConfig != null) {
            result.put("indexConfig", this.indexConfig.toMap());
        }
        return result;
    }

    private void addCacheConfig(Map queryMap, CacheConfig ... cache) {
        if (cache == null) {
            return;
        }
        for (CacheConfig config : cache) {
            if (config == null) continue;
            queryMap.put(config.getNodeName(), config.toMap());
        }
    }

    @Override
    protected Properties getSubstituteProperties() {
        Map<String, Object> p = this.getOverlay().getUserProps();
        if (p == null || p.isEmpty()) {
            return super.getSubstituteProperties();
        }
        Properties result = new Properties(super.getSubstituteProperties());
        result.putAll(p);
        return result;
    }

    public ConfigOverlay getOverlay() {
        if (this.overlay == null) {
            this.overlay = SolrConfig.getConfigOverlay(this.getResourceLoader());
        }
        return this.overlay;
    }

    public RequestParams getRequestParams() {
        if (this.requestParams == null) {
            return this.refreshRequestParams();
        }
        return this.requestParams;
    }

    public RequestParams refreshRequestParams() {
        this.requestParams = RequestParams.getFreshRequestParams(this.getResourceLoader(), this.requestParams);
        log.info("current version of requestparams : {}", (Object)this.requestParams.getZnodeVersion());
        return this.requestParams;
    }

    static {
        HashMap<String, SolrPluginInfo> map = new HashMap<String, SolrPluginInfo>();
        for (SolrPluginInfo plugin : plugins) {
            map.put(plugin.clazz.getName(), plugin);
        }
        classVsSolrPluginInfo = Collections.unmodifiableMap(map);
    }

    public static class UpdateHandlerInfo
    implements MapSerializable {
        public final String className;
        public final int autoCommmitMaxDocs;
        public final int autoCommmitMaxTime;
        public final int autoSoftCommmitMaxDocs;
        public final int autoSoftCommmitMaxTime;
        public final boolean indexWriterCloseWaitsForMerges;
        public final boolean openSearcher;
        public final boolean commitWithinSoftCommit;

        public UpdateHandlerInfo(String className, int autoCommmitMaxDocs, int autoCommmitMaxTime, boolean indexWriterCloseWaitsForMerges, boolean openSearcher, int autoSoftCommmitMaxDocs, int autoSoftCommmitMaxTime, boolean commitWithinSoftCommit) {
            this.className = className;
            this.autoCommmitMaxDocs = autoCommmitMaxDocs;
            this.autoCommmitMaxTime = autoCommmitMaxTime;
            this.indexWriterCloseWaitsForMerges = indexWriterCloseWaitsForMerges;
            this.openSearcher = openSearcher;
            this.autoSoftCommmitMaxDocs = autoSoftCommmitMaxDocs;
            this.autoSoftCommmitMaxTime = autoSoftCommmitMaxTime;
            this.commitWithinSoftCommit = commitWithinSoftCommit;
        }

        @Override
        public Map<String, Object> toMap() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("indexWriter", Utils.makeMap("closeWaitsForMerges", this.indexWriterCloseWaitsForMerges));
            result.put("commitWithin", Utils.makeMap("softCommit", this.commitWithinSoftCommit));
            result.put("autoCommit", Utils.makeMap("maxDocs", this.autoCommmitMaxDocs, "maxTime", this.autoCommmitMaxTime, "openSearcher", this.openSearcher));
            result.put("autoSoftCommit", Utils.makeMap("maxDocs", this.autoSoftCommmitMaxDocs, "maxTime", this.autoSoftCommmitMaxTime));
            return result;
        }
    }

    public static class HttpCachingConfig
    implements MapSerializable {
        private static final String CACHE_PRE = "requestDispatcher/httpCaching/";
        private static final Pattern MAX_AGE = Pattern.compile("\\bmax-age=(\\d+)");
        private final boolean never304;
        private final String etagSeed;
        private final String cacheControlHeader;
        private final Long maxAge;
        private final LastModFrom lastModFrom;

        @Override
        public Map<String, Object> toMap() {
            return Utils.makeMap("never304", this.never304, "etagSeed", this.etagSeed, "lastModFrom", this.lastModFrom.name().toLowerCase(Locale.ROOT), "cacheControl", this.cacheControlHeader);
        }

        private HttpCachingConfig(SolrConfig conf) {
            this.never304 = conf.getBool("requestDispatcher/httpCaching/@never304", false);
            this.etagSeed = conf.get("requestDispatcher/httpCaching/@etagSeed", "Solr");
            this.lastModFrom = LastModFrom.parse(conf.get("requestDispatcher/httpCaching/@lastModFrom", "openTime"));
            this.cacheControlHeader = conf.get("requestDispatcher/httpCaching/cacheControl", null);
            Long tmp = null;
            if (null != this.cacheControlHeader) {
                try {
                    Matcher ttlMatcher = MAX_AGE.matcher(this.cacheControlHeader);
                    String ttlStr = ttlMatcher.find() ? ttlMatcher.group(1) : null;
                    tmp = null != ttlStr && !"".equals(ttlStr) ? Long.valueOf(ttlStr) : null;
                }
                catch (Exception e) {
                    log.warn("Ignoring exception while attempting to extract max-age from cacheControl config: " + this.cacheControlHeader, (Throwable)e);
                }
            }
            this.maxAge = tmp;
        }

        public boolean isNever304() {
            return this.never304;
        }

        public String getEtagSeed() {
            return this.etagSeed;
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public Long getMaxAge() {
            return this.maxAge;
        }

        public LastModFrom getLastModFrom() {
            return this.lastModFrom;
        }

        public static enum LastModFrom {
            OPENTIME,
            DIRLASTMOD,
            BOGUS;


            public static LastModFrom parse(String s) {
                try {
                    return LastModFrom.valueOf(s.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    log.warn("Unrecognized value for lastModFrom: " + s, (Throwable)e);
                    return BOGUS;
                }
            }
        }
    }

    public static class JmxConfiguration
    implements MapSerializable {
        public boolean enabled = false;
        public String agentId;
        public String serviceUrl;
        public String rootName;

        public JmxConfiguration(boolean enabled, String agentId, String serviceUrl, String rootName) {
            this.enabled = enabled;
            this.agentId = agentId;
            this.serviceUrl = serviceUrl;
            this.rootName = rootName;
            if (agentId != null && serviceUrl != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Incorrect JMX Configuration in solrconfig.xml, both agentId and serviceUrl cannot be specified at the same time");
            }
        }

        @Override
        public Map<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("agentId", this.agentId);
            map.put("serviceUrl", this.serviceUrl);
            map.put("rootName", this.rootName);
            return map;
        }
    }

    public static class SolrPluginInfo {
        public final Class clazz;
        public final String tag;
        public final Set<PluginOpts> options;

        private SolrPluginInfo(Class clz, String tag, PluginOpts ... opts) {
            this.clazz = clz;
            this.tag = tag;
            this.options = opts == null ? Collections.EMPTY_SET : EnumSet.of(PluginOpts.NOOP, opts);
        }

        public String getCleanTag() {
            return this.tag.replaceAll("/", "");
        }

        public String getTagCleanLower() {
            return this.getCleanTag().toLowerCase(Locale.ROOT);
        }
    }

    public static enum PluginOpts {
        MULTI_OK,
        REQUIRE_NAME,
        REQUIRE_NAME_IN_OVERLAY,
        REQUIRE_CLASS,
        LAZY,
        NOOP;

    }
}

