/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;

public class DumpRequestHandler
extends RequestHandlerBase {
    private List<String> subpaths;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        rsp.add("params", req.getParams().toNamedList());
        String[] returnParams = req.getParams().getParams("param");
        if (returnParams != null) {
            NamedList params = (NamedList)rsp.getValues().get("params");
            for (String returnParam : returnParams) {
                String[] vals = req.getParams().getParams(returnParam);
                if (vals == null) continue;
                if (vals.length == 1) {
                    params.add(returnParam, vals[0]);
                    continue;
                }
                params.add(returnParam, vals);
            }
        }
        if (Boolean.TRUE.equals(req.getParams().getBool("getdefaults"))) {
            NamedList def = (NamedList)this.initArgs.get("defaults");
            rsp.add("getdefaults", def);
        }
        if (Boolean.TRUE.equals(req.getParams().getBool("initArgs"))) {
            rsp.add("initArgs", this.initArgs);
        }
        if (req.getContentStreams() != null) {
            ArrayList streams = new ArrayList();
            for (ContentStream content : req.getContentStreams()) {
                SimpleOrderedMap<Object> stream = new SimpleOrderedMap<Object>();
                stream.add("name", content.getName());
                stream.add("sourceInfo", content.getSourceInfo());
                stream.add("size", content.getSize());
                stream.add("contentType", content.getContentType());
                try (Reader reader = content.getReader();){
                    stream.add("stream", IOUtils.toString((Reader)reader));
                }
                streams.add(stream);
            }
            rsp.add("streams", streams);
        }
        rsp.add("context", req.getContext());
    }

    @Override
    public String getDescription() {
        return "Dump handler (debug)";
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        if (this.subpaths != null && this.subpaths.contains(subPath)) {
            return this;
        }
        return null;
    }

    @Override
    public void init(NamedList args) {
        NamedList nl;
        super.init(args);
        if (args != null && (nl = (NamedList)args.get("defaults")) != null) {
            this.subpaths = nl.getAll("subpath");
        }
    }
}

