/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.RangeFacetRequest;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.IntervalFacets;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SyntaxError;

public class RangeFacetProcessor
extends SimpleFacets {
    public RangeFacetProcessor(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        super(req, docs, params, rb);
    }

    public NamedList<Object> getFacetRangeCounts() throws IOException, SyntaxError {
        SimpleOrderedMap<Object> resOuter = new SimpleOrderedMap<Object>();
        List<Object> rangeFacetRequests = Collections.emptyList();
        try {
            FacetComponent.FacetContext facetContext = FacetComponent.FacetContext.getFacetContext(this.req);
            rangeFacetRequests = facetContext.getAllRangeFacetRequests();
        }
        catch (IllegalStateException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to compute facet ranges, facet context is not set");
        }
        if (rangeFacetRequests.isEmpty()) {
            return resOuter;
        }
        for (RangeFacetRequest rangeFacetRequest : rangeFacetRequests) {
            this.getFacetRangeCounts(rangeFacetRequest, resOuter);
        }
        return resOuter;
    }

    public void getFacetRangeCounts(RangeFacetRequest rangeFacetRequest, NamedList<Object> resOuter) throws IOException, SyntaxError {
        IndexSchema schema = this.searcher.getSchema();
        String key = rangeFacetRequest.getKey();
        String f = rangeFacetRequest.facetOn;
        FacetParams.FacetRangeMethod method = rangeFacetRequest.getMethod();
        SchemaField sf = schema.getField(f);
        FieldType ft = sf.getType();
        if (method.equals((Object)FacetParams.FacetRangeMethod.DV)) {
            assert (ft instanceof TrieField);
            resOuter.add(key, this.getFacetRangeCountsDocValues(rangeFacetRequest));
        } else {
            resOuter.add(key, this.getFacetRangeCounts(rangeFacetRequest));
        }
    }

    private <T extends Comparable<T>> NamedList getFacetRangeCounts(RangeFacetRequest rfr) throws IOException, SyntaxError {
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        NamedList<Integer> counts = new NamedList<Integer>();
        res.add("counts", counts);
        res.add("gap", rfr.getGapObj());
        DocSet docSet = this.computeDocSet(this.docsOrig, rfr.getExcludeTags());
        for (RangeFacetRequest.FacetRange range : rfr.getFacetRanges()) {
            if (range.other != null) {
                res.add(range.other.toString(), this.rangeCount(docSet, rfr, range));
                continue;
            }
            int count = this.rangeCount(docSet, rfr, range);
            if (count < rfr.getMinCount()) continue;
            counts.add(range.lower, count);
        }
        res.add("start", rfr.getStartObj());
        res.add("end", rfr.getEndObj());
        return res;
    }

    private <T extends Comparable<T>> NamedList<Object> getFacetRangeCountsDocValues(RangeFacetRequest rfr) throws IOException, SyntaxError {
        SchemaField sf = rfr.getSchemaField();
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        NamedList<Integer> counts = new NamedList<Integer>();
        res.add("counts", counts);
        ArrayList<IntervalFacets.FacetInterval> intervals = new ArrayList<IntervalFacets.FacetInterval>();
        res.add("gap", rfr.getGapObj());
        int minCount = rfr.getMinCount();
        boolean includeBefore = false;
        boolean includeBetween = false;
        boolean includeAfter = false;
        EnumSet<FacetParams.FacetRangeOther> others = rfr.getOthers();
        if (!others.contains((Object)FacetParams.FacetRangeOther.NONE)) {
            if (others.contains((Object)FacetParams.FacetRangeOther.ALL) || others.contains((Object)FacetParams.FacetRangeOther.BEFORE)) {
                intervals.add(null);
                includeBefore = true;
            }
            if (others.contains((Object)FacetParams.FacetRangeOther.ALL) || others.contains((Object)FacetParams.FacetRangeOther.BETWEEN)) {
                intervals.add(null);
                includeBetween = true;
            }
            if (others.contains((Object)FacetParams.FacetRangeOther.ALL) || others.contains((Object)FacetParams.FacetRangeOther.AFTER)) {
                includeAfter = true;
            }
        }
        IntervalFacets.FacetInterval after = null;
        for (RangeFacetRequest.FacetRange range : rfr.getFacetRanges()) {
            try {
                FacetParams.FacetRangeOther other = FacetParams.FacetRangeOther.get(range.name);
                if (other == null) continue;
                switch (other) {
                    case BEFORE: {
                        assert (range.lower == null);
                        intervals.set(0, new IntervalFacets.FacetInterval(sf, "*", range.upper, range.includeLower, range.includeUpper, FacetParams.FacetRangeOther.BEFORE.toString()));
                        break;
                    }
                    case AFTER: {
                        assert (range.upper == null);
                        after = new IntervalFacets.FacetInterval(sf, range.lower, "*", range.includeLower, range.includeUpper, FacetParams.FacetRangeOther.AFTER.toString());
                        break;
                    }
                    case BETWEEN: {
                        intervals.set(includeBefore ? 1 : 0, new IntervalFacets.FacetInterval(sf, range.lower, range.upper, range.includeLower, range.includeUpper, FacetParams.FacetRangeOther.BETWEEN.toString()));
                    }
                }
            }
            catch (SolrException other) {
                intervals.add(new IntervalFacets.FacetInterval(sf, range.lower, range.upper, range.includeLower, range.includeUpper, range.lower));
            }
        }
        if (includeAfter) {
            assert (after != null);
            intervals.add(after);
        }
        IntervalFacets.FacetInterval[] intervalsArray = intervals.toArray(new IntervalFacets.FacetInterval[intervals.size()]);
        intervals = null;
        new IntervalFacets(sf, this.searcher, this.computeDocSet(this.docsOrig, rfr.getExcludeTags()), intervalsArray);
        int intervalIndex = 0;
        int lastIntervalIndex = intervalsArray.length - 1;
        if (includeBefore) {
            res.add(intervalsArray[intervalIndex].getKey(), intervalsArray[intervalIndex].getCount());
            ++intervalIndex;
        }
        if (includeBetween) {
            res.add(intervalsArray[intervalIndex].getKey(), intervalsArray[intervalIndex].getCount());
            ++intervalIndex;
        }
        if (includeAfter) {
            res.add(intervalsArray[lastIntervalIndex].getKey(), intervalsArray[lastIntervalIndex].getCount());
            --lastIntervalIndex;
        }
        while (intervalIndex <= lastIntervalIndex) {
            IntervalFacets.FacetInterval interval = intervalsArray[intervalIndex];
            if (interval.getCount() >= minCount) {
                counts.add(interval.getKey(), interval.getCount());
            }
            ++intervalIndex;
        }
        res.add("start", rfr.getStartObj());
        res.add("end", rfr.getEndObj());
        return res;
    }

    protected int rangeCount(DocSet subset, RangeFacetRequest rfr, RangeFacetRequest.FacetRange fr) throws IOException, SyntaxError {
        SchemaField schemaField = rfr.getSchemaField();
        Query rangeQ = schemaField.getType().getRangeQuery(null, schemaField, fr.lower, fr.upper, fr.includeLower, fr.includeUpper);
        if (rfr.isGroupFacet()) {
            return this.getGroupedFacetQueryCount(rangeQ, subset);
        }
        return this.searcher.numDocs(rangeQ, subset);
    }
}

