/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.Closeable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.RefCounted;

public abstract class SolrQueryRequestBase
implements SolrQueryRequest,
Closeable {
    protected final SolrCore core;
    protected final SolrParams origParams;
    protected volatile IndexSchema schema;
    protected SolrParams params;
    protected Map<Object, Object> context;
    protected Iterable<ContentStream> streams;
    protected Map<String, Object> json;
    private final RTimerTree requestTimer;
    protected final long startTime;
    protected RefCounted<SolrIndexSearcher> searcherHolder;

    @SuppressForbidden(reason="Need currentTimeMillis to get start time for request (to be used for stats/debugging)")
    public SolrQueryRequestBase(SolrCore core, SolrParams params, RTimerTree requestTimer) {
        this.core = core;
        this.schema = null == core ? null : core.getLatestSchema();
        this.params = this.origParams = params;
        this.requestTimer = requestTimer;
        this.startTime = System.currentTimeMillis();
    }

    public SolrQueryRequestBase(SolrCore core, SolrParams params) {
        this(core, params, new RTimerTree());
    }

    @Override
    public Map<Object, Object> getContext() {
        if (this.context == null) {
            this.context = new HashMap<Object, Object>();
        }
        return this.context;
    }

    @Override
    public SolrParams getParams() {
        return this.params;
    }

    @Override
    public SolrParams getOriginalParams() {
        return this.origParams;
    }

    @Override
    public void setParams(SolrParams params) {
        this.params = params;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public RTimerTree getRequestTimer() {
        return this.requestTimer;
    }

    @Override
    public SolrIndexSearcher getSearcher() {
        if (this.core == null) {
            return null;
        }
        if (this.searcherHolder == null) {
            this.searcherHolder = this.core.getSearcher();
        }
        return this.searcherHolder.get();
    }

    @Override
    public SolrCore getCore() {
        return this.core;
    }

    @Override
    public IndexSchema getSchema() {
        return this.schema;
    }

    @Override
    public void updateSchemaToLatest() {
        this.schema = this.core.getLatestSchema();
    }

    @Override
    public void close() {
        if (this.searcherHolder != null) {
            this.searcherHolder.decref();
            this.searcherHolder = null;
        }
    }

    @Override
    public Iterable<ContentStream> getContentStreams() {
        return this.streams;
    }

    public void setContentStreams(Iterable<ContentStream> s) {
        this.streams = s;
    }

    @Override
    public String getParamString() {
        return this.origParams.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.params + '}';
    }

    @Override
    public Map<String, Object> getJSON() {
        return this.json;
    }

    @Override
    public void setJSON(Map<String, Object> json) {
        this.json = json;
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }
}

