/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.util.SolrPluginUtils;

public class ExplainAugmenterFactory
extends TransformerFactory {
    protected Style defaultStyle = null;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.defaultStyle = this.defaultUserArgs != null ? ExplainAugmenterFactory.getStyle(this.defaultUserArgs) : Style.nl;
    }

    public static Style getStyle(String str) {
        try {
            return Style.valueOf(str);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Explain Style: " + str);
        }
    }

    @Override
    public DocTransformer create(String field, SolrParams params, SolrQueryRequest req) {
        String s = params.get("style");
        Style style = s == null ? this.defaultStyle : ExplainAugmenterFactory.getStyle(s);
        return new ExplainAugmenter(field, style);
    }

    static class ExplainAugmenter
    extends DocTransformer {
        final String name;
        final Style style;

        public ExplainAugmenter(String display, Style style) {
            this.name = display;
            this.style = style;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void transform(SolrDocument doc, int docid) {
            if (this.context != null && this.context.getQuery() != null) {
                try {
                    Explanation exp = this.context.getSearcher().explain(this.context.getQuery(), docid);
                    if (this.style == Style.nl) {
                        doc.setField(this.name, SolrPluginUtils.explanationToNamedList(exp));
                    } else if (this.style == Style.html) {
                        doc.setField(this.name, exp.toHtml());
                    } else {
                        doc.setField(this.name, exp.toString());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum Style {
        nl,
        text,
        html;

    }
}

