/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.servlet.ResponseUtils;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.OutputRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;

public abstract class BaseSolrResource
extends ServerResource {
    protected static final String SHOW_DEFAULTS = "showDefaults";
    public static final String UPDATE_TIMEOUT_SECS = "updateTimeoutSecs";
    private SolrCore solrCore;
    private IndexSchema schema;
    private SolrQueryRequest solrRequest;
    private SolrQueryResponse solrResponse;
    private QueryResponseWriter responseWriter;
    private String contentType;
    private int updateTimeoutSecs = -1;

    public SolrCore getSolrCore() {
        return this.solrCore;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public SolrQueryRequest getSolrRequest() {
        return this.solrRequest;
    }

    public SolrQueryResponse getSolrResponse() {
        return this.solrResponse;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected int getUpdateTimeoutSecs() {
        return this.updateTimeoutSecs;
    }

    protected BaseSolrResource() {
    }

    public void doInit() throws ResourceException {
        super.doInit();
        this.setNegotiated(false);
        if (this.isExisting()) {
            try {
                SolrRequestInfo solrRequestInfo = SolrRequestInfo.getRequestInfo();
                if (null == solrRequestInfo) {
                    String message = "No handler or core found in " + this.getRequest().getOriginalRef().getPath();
                    this.doError(Status.CLIENT_ERROR_BAD_REQUEST, message);
                    this.setExisting(false);
                } else {
                    this.solrRequest = solrRequestInfo.getReq();
                    if (null == this.solrRequest) {
                        String message = "No handler or core found in " + this.getRequest().getOriginalRef().getPath();
                        this.doError(Status.CLIENT_ERROR_BAD_REQUEST, message);
                        this.setExisting(false);
                    } else {
                        String indent;
                        this.solrResponse = solrRequestInfo.getRsp();
                        this.solrCore = this.solrRequest.getCore();
                        this.schema = this.solrRequest.getSchema();
                        String responseWriterName = this.solrRequest.getParams().get("wt");
                        if (null == responseWriterName) {
                            responseWriterName = "json";
                        }
                        if (null == (indent = this.solrRequest.getParams().get("indent")) || !"off".equals(indent) && !"false".equals(indent)) {
                            ModifiableSolrParams newParams = new ModifiableSolrParams(this.solrRequest.getParams());
                            newParams.remove(indent);
                            newParams.add("indent", "on");
                            this.solrRequest.setParams(newParams);
                        }
                        this.responseWriter = this.solrCore.getQueryResponseWriter(responseWriterName);
                        this.contentType = this.responseWriter.getContentType(this.solrRequest, this.solrResponse);
                        String path = this.getRequest().getRootRef().getPath();
                        if (!"/schema".equals(path)) {
                            int cutoffPoint = path.indexOf("/", 1);
                            String firstPathElement = -1 == cutoffPoint ? path : path.substring(0, cutoffPoint);
                            this.solrRequest.getContext().put("webapp", firstPathElement);
                        }
                        SolrCore.preDecorateResponse(this.solrRequest, this.solrResponse);
                        String updateTimeoutSecsParam = this.getSolrRequest().getParams().get(UPDATE_TIMEOUT_SECS);
                        if (updateTimeoutSecsParam != null) {
                            this.updateTimeoutSecs = updateTimeoutSecsParam instanceof Number ? ((Number)((Object)updateTimeoutSecsParam)).intValue() : Integer.parseInt(updateTimeoutSecsParam.toString());
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)t;
                }
                this.setExisting(false);
                throw new ResourceException(t);
            }
        }
    }

    protected void handlePostExecution(Logger log) {
        this.handleException(log);
        SolrCore.postDecorateResponse(null, this.solrRequest, this.solrResponse);
        this.addDeprecatedWarning();
        if (log.isInfoEnabled() && this.solrResponse.getToLog().size() > 0) {
            log.info(this.solrResponse.getToLogAsString(this.solrCore.getLogId()));
        }
    }

    protected void addDeprecatedWarning() {
        this.solrResponse.add("warn", "This API is deprecated");
    }

    protected void handleException(Logger log) {
        Exception exception = this.getSolrResponse().getException();
        if (null != exception) {
            SimpleOrderedMap info = new SimpleOrderedMap();
            int code = ResponseUtils.getErrorInfo(exception, info, log);
            this.setStatus(Status.valueOf((int)code));
            this.getSolrResponse().add("error", info);
            String message = (String)info.get("msg");
            if (null != message && !message.trim().isEmpty()) {
                this.getSolrResponse().getToLog().add("msg", "{" + message.trim() + "}");
            }
        }
    }

    protected static String urlDecode(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str.replace("+", "%2B"), "UTF-8");
    }

    public class SolrOutputRepresentation
    extends OutputRepresentation {
        public SolrOutputRepresentation() {
            super(MediaType.valueOf((String)BaseSolrResource.this.contentType));
            BaseSolrResource.this.getDimensions().clear();
        }

        public void write(OutputStream outputStream) throws IOException {
            if (BaseSolrResource.this.getRequest().getMethod() != Method.HEAD) {
                QueryResponseWriterUtil.writeQueryResponse(outputStream, BaseSolrResource.this.responseWriter, BaseSolrResource.this.solrRequest, BaseSolrResource.this.solrResponse, BaseSolrResource.this.contentType);
            }
        }
    }
}

