/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema.analysis;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedWordSetResource
extends ManagedResource
implements ManagedResource.ChildResourceSupport {
    public static final String WORD_SET_JSON_FIELD = "wordSet";
    public static final String IGNORE_CASE_INIT_ARG = "ignoreCase";
    private SortedSet<String> managedWords = null;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ManagedWordSetResource(String resourceId, SolrResourceLoader loader, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
        super(resourceId, loader, storageIO);
    }

    public Set<String> getWordSet() {
        return Collections.unmodifiableSet(this.managedWords);
    }

    public boolean getIgnoreCase() {
        return this.getIgnoreCase(this.managedInitArgs);
    }

    public boolean getIgnoreCase(NamedList<?> initArgs) {
        Boolean ignoreCase = initArgs.getBooleanArg(IGNORE_CASE_INIT_ARG);
        return null == ignoreCase ? false : ignoreCase;
    }

    @Override
    protected void onManagedDataLoadedFromStorage(NamedList<?> initArgs, Object data) throws SolrException {
        boolean ignoreCase = this.getIgnoreCase(initArgs);
        if (null == initArgs.get(IGNORE_CASE_INIT_ARG)) {
            initArgs.add(IGNORE_CASE_INIT_ARG, false);
        }
        this.managedWords = new TreeSet<String>();
        if (data != null) {
            List wordList = (List)data;
            if (ignoreCase) {
                for (String word : wordList) {
                    this.managedWords.add(word.toLowerCase(Locale.ROOT));
                }
            } else {
                this.managedWords.addAll(wordList);
            }
        } else {
            this.storeManagedData(new ArrayList(0));
        }
        log.info("Loaded " + this.managedWords.size() + " words for " + this.getResourceId());
    }

    @Override
    public void doGet(BaseSolrResource endpoint, String childId) {
        SolrQueryResponse response = endpoint.getSolrResponse();
        if (childId != null) {
            String key;
            String string = key = this.getIgnoreCase() ? childId.toLowerCase(Locale.ROOT) : childId;
            if (!this.managedWords.contains(key)) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, String.format(Locale.ROOT, "%s not found in %s", childId, this.getResourceId()));
            }
            response.add(childId, key);
        } else {
            response.add(WORD_SET_JSON_FIELD, this.buildMapToStore(this.managedWords));
        }
    }

    @Override
    public synchronized void doDeleteChild(BaseSolrResource endpoint, String childId) {
        String key;
        String string = key = this.getIgnoreCase() ? childId.toLowerCase(Locale.ROOT) : childId;
        if (!this.managedWords.contains(key)) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, String.format(Locale.ROOT, "%s not found in %s", childId, this.getResourceId()));
        }
        this.managedWords.remove(key);
        this.storeManagedData(this.managedWords);
        log.info("Removed word: {}", (Object)key);
    }

    @Override
    protected Object applyUpdatesToManagedData(Object updates) {
        boolean madeChanges = false;
        List words = (List)updates;
        log.info("Applying updates: " + words);
        boolean ignoreCase = this.getIgnoreCase();
        for (String word : words) {
            if (ignoreCase) {
                word = word.toLowerCase(Locale.ROOT);
            }
            if (!this.managedWords.add(word)) continue;
            madeChanges = true;
            log.info("Added word: {}", (Object)word);
        }
        return madeChanges ? this.managedWords : null;
    }

    @Override
    protected boolean updateInitArgs(NamedList<?> updatedArgs) {
        if (updatedArgs == null || updatedArgs.size() == 0) {
            return false;
        }
        boolean currentIgnoreCase = this.getIgnoreCase(this.managedInitArgs);
        boolean updatedIgnoreCase = this.getIgnoreCase(updatedArgs);
        if (currentIgnoreCase && !updatedIgnoreCase) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Changing a managed word set's ignoreCase arg from true to false is not permitted.");
        }
        if (!currentIgnoreCase && updatedIgnoreCase) {
            TreeSet<String> updatedWords = new TreeSet<String>();
            for (String word : this.managedWords) {
                updatedWords.add(word.toLowerCase(Locale.ROOT));
            }
            this.managedWords = updatedWords;
        }
        return super.updateInitArgs(updatedArgs);
    }
}

