/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.ByteArrayInputStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ZkIndexSchemaReader
implements OnReconnect {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ManagedIndexSchemaFactory managedIndexSchemaFactory;
    private SolrZkClient zkClient;
    private String managedSchemaPath;
    private final String uniqueCoreId;
    private boolean isRemoved = false;

    public ZkIndexSchemaReader(ManagedIndexSchemaFactory managedIndexSchemaFactory, SolrCore solrCore) {
        this.managedIndexSchemaFactory = managedIndexSchemaFactory;
        ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)managedIndexSchemaFactory.getResourceLoader();
        this.zkClient = zkLoader.getZkController().getZkClient();
        this.managedSchemaPath = zkLoader.getConfigSetZkPath() + "/" + managedIndexSchemaFactory.getManagedSchemaResourceName();
        this.uniqueCoreId = solrCore.getName() + ":" + solrCore.getStartNanoTime();
        solrCore.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
                CoreContainer cc = core.getCoreDescriptor().getCoreContainer();
                if (cc.isZooKeeperAware()) {
                    log.info("Removing ZkIndexSchemaReader OnReconnect listener as core " + core.getName() + " is shutting down.");
                    ZkIndexSchemaReader.this.isRemoved = true;
                    cc.getZkController().removeOnReconnectListener(ZkIndexSchemaReader.this);
                }
            }

            @Override
            public void postClose(SolrCore core) {
            }
        });
        this.createSchemaWatcher();
        zkLoader.getZkController().addOnReconnectListener(this);
    }

    public Object getSchemaUpdateLock() {
        return this.managedIndexSchemaFactory.getSchemaUpdateLock();
    }

    public void createSchemaWatcher() {
        log.info("Creating ZooKeeper watch for the managed schema at " + this.managedSchemaPath);
        try {
            this.zkClient.exists(this.managedSchemaPath, new Watcher(){

                public void process(WatchedEvent event) {
                    if (ZkIndexSchemaReader.this.isRemoved) {
                        return;
                    }
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    log.info("A schema change: {}, has occurred - updating schema from ZooKeeper ...", (Object)event);
                    try {
                        ZkIndexSchemaReader.this.updateSchema(this, -1);
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                    }
                }
            }, true);
        }
        catch (KeeperException e) {
            String msg = "Error creating ZooKeeper watch for the managed schema";
            log.error("Error creating ZooKeeper watch for the managed schema", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Error creating ZooKeeper watch for the managed schema", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("", (Throwable)e);
        }
    }

    public ManagedIndexSchema refreshSchemaFromZk(int expectedZkVersion) throws KeeperException, InterruptedException {
        this.updateSchema(null, expectedZkVersion);
        return this.managedIndexSchemaFactory.getSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Watcher watcher, int expectedZkVersion) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        Object object = this.getSchemaUpdateLock();
        synchronized (object) {
            ManagedIndexSchema oldSchema = this.managedIndexSchemaFactory.getSchema();
            if (expectedZkVersion == -1 || oldSchema.schemaZkVersion < expectedZkVersion) {
                byte[] data = this.zkClient.getData(this.managedSchemaPath, watcher, stat, true);
                if (stat.getVersion() != oldSchema.schemaZkVersion) {
                    log.info("Retrieved schema version " + stat.getVersion() + " from ZooKeeper");
                    long start = System.nanoTime();
                    InputSource inputSource = new InputSource(new ByteArrayInputStream(data));
                    String resourceName = this.managedIndexSchemaFactory.getManagedSchemaResourceName();
                    ManagedIndexSchema newSchema = new ManagedIndexSchema(this.managedIndexSchemaFactory.getConfig(), resourceName, inputSource, this.managedIndexSchemaFactory.isMutable(), resourceName, stat.getVersion(), oldSchema.getSchemaUpdateLock());
                    this.managedIndexSchemaFactory.setSchema(newSchema);
                    long stop = System.nanoTime();
                    log.info("Finished refreshing schema in " + TimeUnit.MILLISECONDS.convert(stop - start, TimeUnit.NANOSECONDS) + " ms");
                } else {
                    log.info("Current schema version " + oldSchema.schemaZkVersion + " is already the latest");
                }
            }
        }
    }

    @Override
    public void command() {
        try {
            this.createSchemaWatcher();
            this.updateSchema(null, -1);
        }
        catch (Exception exc) {
            log.error("Failed to update managed-schema watcher after session expiration due to: " + exc, (Throwable)exc);
        }
    }

    public String getUniqueCoreId() {
        return this.uniqueCoreId;
    }

    public String toString() {
        return "ZkIndexSchemaReader: " + this.managedSchemaPath + ", uniqueCoreId: " + this.uniqueCoreId;
    }

    public int hashCode() {
        return this.managedSchemaPath.hashCode() + this.uniqueCoreId.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ZkIndexSchemaReader)) {
            return false;
        }
        ZkIndexSchemaReader that = (ZkIndexSchemaReader)other;
        return this.managedSchemaPath.equals(that.managedSchemaPath) && this.uniqueCoreId.equals(that.uniqueCoreId);
    }
}

