/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.DocTransformers;
import org.apache.solr.response.transform.RenameFieldTransformer;
import org.apache.solr.response.transform.ScoreAugmenter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.response.transform.ValueSourceAugmenter;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;

public class SolrReturnFields
extends ReturnFields {
    public static final String SCORE = "score";
    private final List<String> globs = new ArrayList<String>(1);
    private final Set<String> fields = new HashSet<String>();
    private Set<String> okFieldNames = new HashSet<String>();
    private Set<String> reqFieldNames = null;
    protected DocTransformer transformer;
    protected boolean _wantsScore = false;
    protected boolean _wantsAllFields = false;

    public SolrReturnFields() {
        this._wantsAllFields = true;
    }

    public SolrReturnFields(SolrQueryRequest req) {
        this(req.getParams().getParams("fl"), req);
    }

    public SolrReturnFields(String fl, SolrQueryRequest req) {
        if (fl == null) {
            this.parseFieldList(null, req);
        } else if (fl.trim().length() == 0) {
            this._wantsScore = true;
            this._wantsAllFields = true;
            this.transformer = new ScoreAugmenter(SCORE);
        } else {
            this.parseFieldList(new String[]{fl}, req);
        }
    }

    public SolrReturnFields(String[] fl, SolrQueryRequest req) {
        this.parseFieldList(fl, req);
    }

    private void parseFieldList(String[] fl, SolrQueryRequest req) {
        this._wantsScore = false;
        this._wantsAllFields = false;
        if (fl == null || fl.length == 0 || fl.length == 1 && fl[0].length() == 0) {
            this._wantsAllFields = true;
            return;
        }
        NamedList<String> rename = new NamedList<String>();
        DocTransformers augmenters = new DocTransformers();
        for (String fieldList : fl) {
            this.add(fieldList, rename, augmenters, req);
        }
        for (int i = 0; i < rename.size(); ++i) {
            boolean copy;
            String from = rename.getName(i);
            String to = rename.getVal(i);
            this.okFieldNames.add(to);
            boolean bl = copy = this.reqFieldNames != null && this.reqFieldNames.contains(from);
            if (!copy) {
                for (int j = i + 1; j < rename.size(); ++j) {
                    if (!from.equals(rename.getName(j))) continue;
                    rename.setName(j, to);
                    if (this.reqFieldNames == null) {
                        this.reqFieldNames = new LinkedHashSet<String>();
                    }
                    this.reqFieldNames.add(to);
                }
            }
            augmenters.addTransformer(new RenameFieldTransformer(from, to, copy));
        }
        if (!this._wantsAllFields && !this.globs.isEmpty()) {
            this.fields.clear();
        }
        if (augmenters.size() == 1) {
            this.transformer = augmenters.getTransformer(0);
        } else if (augmenters.size() > 1) {
            this.transformer = augmenters;
        }
    }

    public static String getFieldName(StrParser sp) {
        char ch;
        sp.eatws();
        int id_start = sp.pos;
        if (sp.pos < sp.end && (ch = sp.val.charAt(sp.pos)) != '$' && Character.isJavaIdentifierStart(ch)) {
            ++sp.pos;
            while (sp.pos < sp.end && (Character.isJavaIdentifierPart(ch = sp.val.charAt(sp.pos)) || ch == '.' || ch == '-')) {
                ++sp.pos;
            }
            return sp.val.substring(id_start, sp.pos);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void add(String fl, NamedList<String> rename, DocTransformers augmenters, SolrQueryRequest req) {
        if (fl == null) {
            return;
        }
        try {
            StrParser sp = new StrParser(fl);
            while (true) {
                String funcStr;
                sp.opt(',');
                sp.eatws();
                if (sp.pos >= sp.end) {
                    return;
                }
                int start = sp.pos;
                String key = null;
                String field = SolrReturnFields.getFieldName(sp);
                char ch = sp.ch();
                if (field != null) {
                    if (sp.opt(':')) {
                        key = field;
                        field = null;
                        sp.eatws();
                        start = sp.pos;
                    } else {
                        if (Character.isWhitespace(ch) || ch == ',' || ch == '\u0000') {
                            this.addField(field, key, augmenters, false);
                            continue;
                        }
                        sp.pos = start;
                        field = null;
                    }
                }
                if (key != null) {
                    field = sp.getId(null);
                    ch = sp.ch();
                    if (field != null && (Character.isWhitespace(ch) || ch == ',' || ch == '\u0000')) {
                        rename.add(field, key);
                        this.addField(field, key, augmenters, false);
                        continue;
                    }
                    sp.pos = start;
                    field = null;
                }
                if (field == null) {
                    field = sp.getGlobbedId(null);
                    ch = sp.ch();
                    if (field != null && (Character.isWhitespace(ch) || ch == ',' || ch == '\u0000')) {
                        if ("*".equals(field)) {
                            this._wantsAllFields = true;
                            continue;
                        }
                        this.globs.add(field);
                        continue;
                    }
                    sp.pos = start;
                }
                if ((funcStr = sp.val.substring(start)).startsWith("[")) {
                    DocTransformer t;
                    TransformerFactory factory;
                    ModifiableSolrParams augmenterParams = new ModifiableSolrParams();
                    int end = QueryParsing.parseLocalParams(funcStr, 0, augmenterParams, req.getParams(), "[", ']');
                    sp.pos += end;
                    String string = augmenterParams.get("type");
                    augmenterParams.remove("type");
                    String disp = key;
                    if (disp == null) {
                        disp = '[' + string + ']';
                    }
                    if ((factory = req.getCore().getTransformerFactory(string)) != null && (t = factory.create(disp, augmenterParams, req)) != null) {
                        String[] extra;
                        if (!this._wantsAllFields && (extra = t.getExtraRequestFields()) != null) {
                            for (String f : extra) {
                                this.fields.add(f);
                            }
                        }
                        augmenters.addTransformer(t);
                    }
                    this.addField(field, disp, augmenters, true);
                    continue;
                }
                QParser parser = QParser.getParser(funcStr, "func", req);
                Query q = null;
                Object var13_17 = null;
                try {
                    void var13_20;
                    SolrParams localParams;
                    block30: {
                        block31: {
                            if (!(parser instanceof FunctionQParser)) break block31;
                            FunctionQParser fparser = (FunctionQParser)parser;
                            fparser.setParseMultipleSources(false);
                            fparser.setParseToEnd(false);
                            q = fparser.getQuery();
                            if (fparser.localParams != null) {
                                if (fparser.valFollowedParams) {
                                    int leftOver = fparser.sp.end - fparser.sp.pos;
                                    sp.pos = sp.end - leftOver;
                                    break block30;
                                } else {
                                    sp.pos = start + fparser.localParamsEnd;
                                }
                                break block30;
                            } else {
                                int leftOver = fparser.sp.end - fparser.sp.pos;
                                sp.pos = sp.end - leftOver;
                            }
                            break block30;
                        }
                        q = parser.getQuery();
                        assert (parser.getLocalParams() != null);
                        sp.pos = start + parser.localParamsEnd;
                    }
                    funcStr = sp.val.substring(start, sp.pos);
                    if (q instanceof FunctionQuery) {
                        ValueSource valueSource = ((FunctionQuery)q).getValueSource();
                    } else {
                        QueryValueSource queryValueSource = new QueryValueSource(q, 0.0f);
                    }
                    if (key == null && (localParams = parser.getLocalParams()) != null) {
                        key = localParams.get("key");
                    }
                    if (key == null) {
                        key = funcStr;
                    }
                    this.addField(funcStr, key, augmenters, true);
                    augmenters.addTransformer(new ValueSourceAugmenter(key, parser, (ValueSource)var13_20));
                }
                catch (SyntaxError e) {
                    sp.pos = start;
                    field = sp.getSimpleString();
                    if (req.getSchema().getFieldOrNull(field) == null) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing fieldname: " + e.getMessage(), (Throwable)e);
                    this.addField(field, key, augmenters, false);
                    if (key == null) continue;
                    rename.add(field, key);
                }
            }
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing fieldname", (Throwable)e);
        }
    }

    private void addField(String field, String key, DocTransformers augmenters, boolean isPseudoField) {
        if (this.reqFieldNames == null) {
            this.reqFieldNames = new LinkedHashSet<String>();
        }
        if (key == null) {
            this.reqFieldNames.add(field);
        } else {
            this.reqFieldNames.add(key);
        }
        if (!isPseudoField) {
            this.fields.add(field);
        }
        this.okFieldNames.add(field);
        this.okFieldNames.add(key);
        if (SCORE.equals(field)) {
            this._wantsScore = true;
            String disp = key == null ? field : key;
            augmenters.addTransformer(new ScoreAugmenter(disp));
        }
    }

    @Override
    public Set<String> getLuceneFieldNames() {
        return this.getLuceneFieldNames(false);
    }

    @Override
    public Set<String> getLuceneFieldNames(boolean ignoreWantsAll) {
        if (ignoreWantsAll) {
            return this.fields;
        }
        return this._wantsAllFields || this.fields.isEmpty() ? null : this.fields;
    }

    @Override
    public Set<String> getRequestedFieldNames() {
        if (this._wantsAllFields || this.reqFieldNames == null || this.reqFieldNames.isEmpty()) {
            return null;
        }
        return this.reqFieldNames;
    }

    @Override
    public boolean hasPatternMatching() {
        return !this.globs.isEmpty();
    }

    @Override
    public boolean wantsField(String name) {
        if (this._wantsAllFields || this.okFieldNames.contains(name)) {
            return true;
        }
        for (String s : this.globs) {
            if (!FilenameUtils.wildcardMatch((String)name, (String)s)) continue;
            this.okFieldNames.add(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean wantsAllFields() {
        return this._wantsAllFields;
    }

    @Override
    public boolean wantsScore() {
        return this._wantsScore;
    }

    @Override
    public DocTransformer getTransformer() {
        return this.transformer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SolrReturnFields=(");
        sb.append("globs=");
        sb.append(this.globs);
        sb.append(",fields=");
        sb.append(this.fields);
        sb.append(",okFieldNames=");
        sb.append(this.okFieldNames);
        sb.append(",reqFieldNames=");
        sb.append(this.reqFieldNames);
        sb.append(",transformer=");
        sb.append(this.transformer);
        sb.append(",wantsScore=");
        sb.append(this._wantsScore);
        sb.append(",wantsAllFields=");
        sb.append(this._wantsAllFields);
        sb.append(')');
        return sb.toString();
    }
}

