/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetBucketMerger;
import org.apache.solr.search.facet.FacetMerger;

class FacetBucket {
    final FacetBucketMerger parent;
    final Comparable bucketValue;
    final int bucketNumber;
    long count;
    Map<String, FacetMerger> subs;

    public FacetBucket(FacetBucketMerger parent, Comparable bucketValue, int bucketNumber) {
        this.parent = parent;
        this.bucketValue = bucketValue;
        this.bucketNumber = bucketNumber;
    }

    public long getCount() {
        return this.count;
    }

    FacetMerger getExistingMerger(String key) {
        if (this.subs == null) {
            return null;
        }
        return this.subs.get(key);
    }

    private FacetMerger getMerger(String key, Object prototype) {
        FacetMerger merger = null;
        if (this.subs != null && (merger = this.subs.get(key)) != null) {
            return merger;
        }
        merger = this.parent.createFacetMerger(key, prototype);
        if (merger != null) {
            if (this.subs == null) {
                this.subs = new HashMap<String, FacetMerger>();
            }
            this.subs.put(key, merger);
        }
        return merger;
    }

    public void mergeBucket(SimpleOrderedMap bucket, FacetMerger.Context mcontext) {
        for (int i = 0; i < bucket.size(); ++i) {
            FacetMerger merger;
            String key = bucket.getName(i);
            Object val = bucket.getVal(i);
            if ("count".equals(key)) {
                this.count += ((Number)val).longValue();
                continue;
            }
            if ("val".equals(key) || (merger = this.getMerger(key, val)) == null) continue;
            merger.merge(val, mcontext);
        }
    }

    public SimpleOrderedMap getMergedBucket() {
        SimpleOrderedMap<Object> out = new SimpleOrderedMap<Object>((this.subs == null ? 0 : this.subs.size()) + 2);
        if (this.bucketValue != null) {
            out.add("val", this.bucketValue);
        }
        out.add("count", this.count);
        if (this.subs != null) {
            for (Map.Entry<String, FacetMerger> mergerEntry : this.subs.entrySet()) {
                FacetMerger subMerger = mergerEntry.getValue();
                out.add(mergerEntry.getKey(), subMerger.getMergedResult());
            }
        }
        return out;
    }
}

