/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetFieldMerger;
import org.apache.solr.search.facet.FacetFieldProcessorDV;
import org.apache.solr.search.facet.FacetFieldProcessorNumeric;
import org.apache.solr.search.facet.FacetFieldProcessorStream;
import org.apache.solr.search.facet.FacetFieldProcessorUIF;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRequest;

public class FacetField
extends FacetRequest {
    String field;
    long offset;
    long limit = 10L;
    long mincount = 1L;
    boolean missing;
    boolean allBuckets;
    boolean numBuckets;
    String prefix;
    String sortVariable;
    SortDirection sortDirection;
    FacetMethod method;
    int cacheDf;
    Boolean perSeg;

    @Override
    public FacetProcessor createFacetProcessor(FacetContext fcontext) {
        boolean multiToken;
        SchemaField sf = fcontext.searcher.getSchema().getField(this.field);
        FieldType ft = sf.getType();
        boolean bl = multiToken = sf.multiValued() || ft.multiValuedFieldCache();
        if (this.method == FacetMethod.ENUM && sf.indexed()) {
            throw new UnsupportedOperationException();
        }
        if (this.method == FacetMethod.STREAM && sf.indexed()) {
            return new FacetFieldProcessorStream(fcontext, this, sf);
        }
        FieldType.NumericType ntype = ft.getNumericType();
        if (!multiToken) {
            if (ntype != null) {
                return new FacetFieldProcessorNumeric(fcontext, this, sf);
            }
            return new FacetFieldProcessorDV(fcontext, this, sf);
        }
        if (sf.hasDocValues() || this.method == FacetMethod.DV) {
            return new FacetFieldProcessorDV(fcontext, this, sf);
        }
        return new FacetFieldProcessorUIF(fcontext, this, sf);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new FacetFieldMerger(this);
    }

    @Override
    public Map<String, Object> getFacetDescription() {
        HashMap<String, Object> descr = new HashMap<String, Object>();
        descr.put("field", this.field);
        descr.put("limit", new Long(this.limit));
        return descr;
    }

    public static enum FacetMethod {
        DV,
        UIF,
        ENUM,
        STREAM,
        SMART;


        public static FacetMethod fromString(String method) {
            if (method == null || method.length() == 0) {
                return null;
            }
            if ("dv".equals(method)) {
                return DV;
            }
            if ("uif".equals(method)) {
                return UIF;
            }
            if ("enum".equals(method)) {
                return ENUM;
            }
            if ("smart".equals(method)) {
                return SMART;
            }
            if ("stream".equals(method)) {
                return STREAM;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown FacetField method " + method);
        }
    }

    public static enum SortDirection {
        asc(-1),
        desc(1);

        private final int multiplier;

        private SortDirection(int multiplier) {
            this.multiplier = multiplier;
        }

        public int getMultiplier() {
            return this.multiplier;
        }
    }
}

