/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetBucket;
import org.apache.solr.search.facet.FacetBucketMerger;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetSortableMerger;

class FacetFieldMerger
extends FacetBucketMerger<FacetField> {
    FacetBucket missingBucket;
    FacetBucket allBuckets;
    FacetMerger numBuckets;
    LinkedHashMap<Object, FacetBucket> buckets = new LinkedHashMap();
    List<FacetBucket> sortedBuckets;
    int numReturnedBuckets;

    public FacetFieldMerger(FacetField freq) {
        super(freq);
    }

    @Override
    public void merge(Object facetResult, FacetMerger.Context mcontext) {
        this.merge((SimpleOrderedMap)facetResult, mcontext);
    }

    protected void merge(SimpleOrderedMap facetResult, FacetMerger.Context mcontext) {
        Object nb;
        Object o;
        if (((FacetField)this.freq).missing && (o = facetResult.get("missing")) != null) {
            if (this.missingBucket == null) {
                this.missingBucket = this.newBucket(null);
            }
            this.missingBucket.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        if (((FacetField)this.freq).allBuckets && (o = facetResult.get("allBuckets")) != null) {
            if (this.allBuckets == null) {
                this.allBuckets = this.newBucket(null);
            }
            this.allBuckets.mergeBucket((SimpleOrderedMap)o, mcontext);
        }
        List bucketList = (List)facetResult.get("buckets");
        this.numReturnedBuckets += bucketList.size();
        this.mergeBucketList(bucketList, mcontext);
        if (((FacetField)this.freq).numBuckets && (nb = facetResult.get("numBuckets")) != null) {
            if (this.numBuckets == null) {
                this.numBuckets = new FacetNumBucketsMerger();
            }
            this.numBuckets.merge(nb, mcontext);
        }
    }

    public void mergeBucketList(List<SimpleOrderedMap> bucketList, FacetMerger.Context mcontext) {
        for (SimpleOrderedMap bucketRes : bucketList) {
            Comparable bucketVal = (Comparable)bucketRes.get("val");
            FacetBucket bucket = this.buckets.get(bucketVal);
            if (bucket == null) {
                bucket = this.newBucket(bucketVal);
                this.buckets.put(bucketVal, bucket);
            }
            bucket.mergeBucket(bucketRes, mcontext);
        }
    }

    public void sortBuckets() {
        this.sortedBuckets = new ArrayList<FacetBucket>(this.buckets.values());
        Comparator<FacetBucket> comparator = null;
        FacetField.SortDirection direction = ((FacetField)this.freq).sortDirection;
        final int sortMul = direction.getMultiplier();
        if ("count".equals(((FacetField)this.freq).sortVariable)) {
            comparator = new Comparator<FacetBucket>(){

                @Override
                public int compare(FacetBucket o1, FacetBucket o2) {
                    int v = -Long.compare(o1.count, o2.count) * sortMul;
                    return v == 0 ? o1.bucketValue.compareTo(o2.bucketValue) : v;
                }
            };
            Collections.sort(this.sortedBuckets, comparator);
        } else if ("index".equals(((FacetField)this.freq).sortVariable)) {
            comparator = new Comparator<FacetBucket>(){

                @Override
                public int compare(FacetBucket o1, FacetBucket o2) {
                    return -o1.bucketValue.compareTo(o2.bucketValue) * sortMul;
                }
            };
            Collections.sort(this.sortedBuckets, comparator);
        } else {
            String key = ((FacetField)this.freq).sortVariable;
            ArrayList<SortVal> lst = new ArrayList<SortVal>(this.buckets.size());
            ArrayList<FacetBucket> nulls = new ArrayList<FacetBucket>(this.buckets.size() >> 1);
            for (int i = 0; i < this.sortedBuckets.size(); ++i) {
                FacetBucket bucket = this.sortedBuckets.get(i);
                FacetMerger merger = bucket.getExistingMerger(key);
                if (merger == null) {
                    nulls.add(bucket);
                }
                if (merger == null) continue;
                SortVal sv = new SortVal();
                sv.bucket = bucket;
                sv.merger = (FacetSortableMerger)merger;
                sv.direction = direction;
                lst.add(sv);
            }
            Collections.sort(lst);
            Collections.sort(nulls, new Comparator<FacetBucket>(){

                @Override
                public int compare(FacetBucket o1, FacetBucket o2) {
                    return o1.bucketValue.compareTo(o2.bucketValue);
                }
            });
            ArrayList<FacetBucket> out = new ArrayList<FacetBucket>(this.buckets.size());
            for (SortVal sv : lst) {
                out.add(sv.bucket);
            }
            out.addAll(nulls);
            this.sortedBuckets = out;
        }
    }

    @Override
    public Object getMergedResult() {
        SimpleOrderedMap<Serializable> result = new SimpleOrderedMap<Serializable>();
        if (this.numBuckets != null) {
            int removed = 0;
            if (((FacetField)this.freq).mincount > 1L) {
                for (FacetBucket bucket : this.buckets.values()) {
                    if (bucket.count >= ((FacetField)this.freq).mincount) continue;
                    ++removed;
                }
            }
            result.add("numBuckets", Long.valueOf(((Number)this.numBuckets.getMergedResult()).longValue() - (long)removed));
        }
        this.sortBuckets();
        int first = (int)((FacetField)this.freq).offset;
        int end = ((FacetField)this.freq).limit >= 0L ? first + (int)((FacetField)this.freq).limit : Integer.MAX_VALUE;
        int last = Math.min(this.sortedBuckets.size(), end);
        ArrayList<SimpleOrderedMap> resultBuckets = new ArrayList<SimpleOrderedMap>(Math.max(0, last - first));
        int off = (int)((FacetField)this.freq).offset;
        int lim = ((FacetField)this.freq).limit >= 0L ? (int)((FacetField)this.freq).limit : Integer.MAX_VALUE;
        for (FacetBucket bucket : this.sortedBuckets) {
            if (bucket.getCount() < ((FacetField)this.freq).mincount) continue;
            if (off > 0) {
                --off;
                continue;
            }
            if (resultBuckets.size() >= lim) break;
            resultBuckets.add(bucket.getMergedBucket());
        }
        result.add("buckets", resultBuckets);
        if (this.missingBucket != null) {
            result.add("missing", this.missingBucket.getMergedBucket());
        }
        if (this.allBuckets != null) {
            result.add("allBuckets", this.allBuckets.getMergedBucket());
        }
        return result;
    }

    private class FacetNumBucketsMerger
    extends FacetMerger {
        long sumBuckets;
        long shardsMissingSum;
        long shardsTruncatedSum;
        Set<Object> values;

        private FacetNumBucketsMerger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            SimpleOrderedMap map = (SimpleOrderedMap)facetResult;
            long numBuckets = ((Number)map.get("numBuckets")).longValue();
            this.sumBuckets += numBuckets;
            List vals = (List)map.get("vals");
            if (vals != null) {
                if (this.values == null) {
                    this.values = new HashSet<Object>(vals.size() * 4);
                }
                this.values.addAll(vals);
                if (numBuckets > (long)this.values.size()) {
                    this.shardsTruncatedSum += numBuckets - (long)this.values.size();
                }
            } else {
                this.shardsMissingSum += numBuckets;
            }
        }

        @Override
        public Object getMergedResult() {
            long exactCount = this.values == null ? 0L : (long)this.values.size();
            return exactCount + this.shardsMissingSum + this.shardsTruncatedSum;
        }
    }

    private static class SortVal
    implements Comparable<SortVal> {
        FacetBucket bucket;
        FacetSortableMerger merger;
        FacetField.SortDirection direction;

        private SortVal() {
        }

        @Override
        public int compareTo(SortVal o) {
            int c = -this.merger.compareTo(o.merger, this.direction) * this.direction.getMultiplier();
            return c == 0 ? this.bucket.bucketValue.compareTo(o.bucket.bucketValue) : c;
        }
    }
}

