/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SpecialSlotAcc;

abstract class FacetFieldProcessorFCBase
extends FacetFieldProcessor {
    BytesRefBuilder prefixRef;
    int startTermIndex;
    int endTermIndex;
    int nTerms;
    int nDocs;
    int maxSlots;
    int allBucketsSlot = -1;

    public FacetFieldProcessorFCBase(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    @Override
    public void process() throws IOException {
        super.process();
        this.sf = this.fcontext.searcher.getSchema().getField(((FacetField)this.freq).field);
        this.response = this.getFieldCacheCounts();
    }

    protected abstract BytesRef lookupOrd(int var1) throws IOException;

    protected abstract void findStartAndEndOrds() throws IOException;

    protected abstract void collectDocs() throws IOException;

    public SimpleOrderedMap<Object> getFieldCacheCounts() throws IOException {
        String prefix = ((FacetField)this.freq).prefix;
        if (prefix == null || prefix.length() == 0) {
            this.prefixRef = null;
        } else {
            this.prefixRef = new BytesRefBuilder();
            this.prefixRef.copyChars((CharSequence)prefix);
        }
        this.findStartAndEndOrds();
        this.maxSlots = this.nTerms;
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsSlot = this.maxSlots++;
        }
        this.createCollectAcc(this.nDocs, this.maxSlots);
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsAcc = new SpecialSlotAcc(this.fcontext, this.collectAcc, this.allBucketsSlot, this.otherAccs, 0);
        }
        this.collectDocs();
        return this.findTopSlots();
    }

    protected SimpleOrderedMap<Object> findTopSlots() throws IOException {
        FacetDebugInfo fdebug;
        int off;
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        int numBuckets = 0;
        ArrayList<Object> bucketVals = null;
        if (((FacetField)this.freq).numBuckets && this.fcontext.isShard()) {
            bucketVals = new ArrayList<Object>(100);
        }
        int n = off = this.fcontext.isShard() ? 0 : (int)((FacetField)this.freq).offset;
        int lim = ((FacetField)this.freq).limit >= 0L ? (this.fcontext.isShard() ? (int)((double)((FacetField)this.freq).limit * 1.1 + 4.0) : (int)((FacetField)this.freq).limit) : Integer.MAX_VALUE;
        int maxsize = (int)(((FacetField)this.freq).limit >= 0L ? ((FacetField)this.freq).offset + (long)lim : 0x7FFFFFFEL);
        maxsize = Math.min(maxsize, this.nTerms);
        final int sortMul = ((FacetField)this.freq).sortDirection.getMultiplier();
        final SlotAcc sortAcc = this.sortAcc;
        PriorityQueue<FacetFieldProcessor.Slot> queue = new PriorityQueue<FacetFieldProcessor.Slot>(maxsize){

            protected boolean lessThan(FacetFieldProcessor.Slot a, FacetFieldProcessor.Slot b) {
                int cmp = sortAcc.compare(a.slot, b.slot) * sortMul;
                return cmp == 0 ? b.slot < a.slot : cmp < 0;
            }
        };
        FacetFieldProcessor.Slot bottom = null;
        for (int i = 0; i < this.nTerms; ++i) {
            if (this.effectiveMincount > 0 && this.countAcc.getCount(i) < this.effectiveMincount) continue;
            ++numBuckets;
            if (bucketVals != null && bucketVals.size() < 100) {
                int ord = this.startTermIndex + i;
                BytesRef br = this.lookupOrd(ord);
                Object val = this.sf.getType().toObject(this.sf, br);
                bucketVals.add(val);
            }
            if (bottom != null) {
                if (sortAcc.compare(bottom.slot, i) * sortMul >= 0) continue;
                bottom.slot = i;
                bottom = (FacetFieldProcessor.Slot)queue.updateTop();
                continue;
            }
            if (lim <= 0) continue;
            FacetFieldProcessor.Slot s = new FacetFieldProcessor.Slot();
            s.slot = i;
            queue.add((Object)s);
            if (queue.size() < maxsize) continue;
            bottom = (FacetFieldProcessor.Slot)queue.top();
        }
        if (((FacetField)this.freq).numBuckets) {
            if (!this.fcontext.isShard()) {
                res.add("numBuckets", numBuckets);
            } else {
                SimpleOrderedMap<Serializable> map = new SimpleOrderedMap<Serializable>(2);
                map.add("numBuckets", Integer.valueOf(numBuckets));
                map.add("vals", bucketVals);
                res.add("numBuckets", map);
            }
        }
        if ((fdebug = this.fcontext.getDebugInfo()) != null) {
            fdebug.putInfoItem("numBuckets", new Long(numBuckets));
        }
        int collectCount = Math.max(0, queue.size() - off);
        assert (collectCount <= lim);
        int[] sortedSlots = new int[collectCount];
        for (int i = collectCount - 1; i >= 0; --i) {
            sortedSlots[i] = ((FacetFieldProcessor.Slot)queue.pop()).slot;
        }
        if (((FacetField)this.freq).allBuckets) {
            SimpleOrderedMap<Object> allBuckets = new SimpleOrderedMap<Object>();
            allBuckets.add("count", this.allBucketsAcc.getSpecialCount());
            if (this.allBucketsAcc != null) {
                this.allBucketsAcc.setValues(allBuckets, this.allBucketsSlot);
            }
            res.add("allBuckets", allBuckets);
        }
        ArrayList<SimpleOrderedMap<Object>> bucketList = new ArrayList<SimpleOrderedMap<Object>>(collectCount);
        res.add("buckets", bucketList);
        boolean needFilter = this.deferredAggs != null || ((FacetField)this.freq).getSubFacets().size() > 0;
        for (int slotNum : sortedSlots) {
            SimpleOrderedMap<Object> bucket = new SimpleOrderedMap<Object>();
            int ord = this.startTermIndex + slotNum;
            BytesRef br = this.lookupOrd(ord);
            Object val = this.sf.getType().toObject(this.sf, br);
            bucket.add("val", val);
            TermQuery filter = needFilter ? new TermQuery(new Term(this.sf.getName(), br)) : null;
            this.fillBucket(bucket, this.countAcc.getCount(slotNum), slotNum, null, (Query)filter);
            bucketList.add(bucket);
        }
        if (((FacetField)this.freq).missing) {
            SimpleOrderedMap<Object> missingBucket = new SimpleOrderedMap<Object>();
            this.fillBucket(missingBucket, FacetFieldProcessorFCBase.getFieldMissingQuery(this.fcontext.searcher, ((FacetField)this.freq).field), null);
            res.add("missing", missingBucket);
        }
        return res;
    }
}

