/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.facet.BlockJoin;
import org.apache.solr.search.join.BlockJoinFacetCollector;
import org.apache.solr.search.join.BlockJoinFacetComponent;
import org.apache.solr.search.join.BlockJoinFieldFacetAccumulator;
import org.apache.solr.search.join.BlockJoinParentQParser;

public class BlockJoinDocSetFacetComponent
extends BlockJoinFacetComponent {
    private final String bjqKey = this.getClass().getSimpleName() + ".bjq";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (BlockJoinDocSetFacetComponent.getChildFacetFields(rb.req) != null) {
            this.validateQuery(rb.getQuery());
            rb.setNeedDocSet(true);
            rb.req.getContext().put(this.bjqKey, this.extractChildQuery(rb.getQuery()));
        }
    }

    private ToParentBlockJoinQuery extractChildQuery(Query query) {
        if (!(query instanceof ToParentBlockJoinQuery)) {
            if (query instanceof BooleanQuery) {
                List clauses = ((BooleanQuery)query).clauses();
                ToParentBlockJoinQuery once = null;
                for (BooleanClause clause : clauses) {
                    if (!(clause.getQuery() instanceof ToParentBlockJoinQuery)) continue;
                    if (once == null) {
                        once = (ToParentBlockJoinQuery)clause.getQuery();
                        continue;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can't choose between " + once + " and " + clause.getQuery());
                }
                if (once != null) {
                    return once;
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Block join faceting is allowed with ToParentBlockJoinQuery only");
        }
        return (ToParentBlockJoinQuery)query;
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        BlockJoinParentQParser.AllParentsAware bjq = (BlockJoinParentQParser.AllParentsAware)((Object)rb.req.getContext().get(this.bjqKey));
        if (bjq != null) {
            DocSet parentResult = rb.getResults().docSet;
            BitDocSet allParentsBitsDocSet = rb.req.getSearcher().getDocSetBits(bjq.getParentQuery());
            DocSet allChildren = BlockJoin.toChildren(parentResult, allParentsBitsDocSet, rb.req.getSearcher().getDocSetBits((Query)new MatchAllDocsQuery()), QueryContext.newContext(rb.req.getSearcher()));
            DocSet childQueryDocSet = rb.req.getSearcher().getDocSet(bjq.getChildQuery());
            DocSet selectedChildren = allChildren.intersection(childQueryDocSet);
            List leaves = rb.req.getSearcher().getIndexReader().leaves();
            Filter filter = selectedChildren.getTopFilter();
            NoDelegateFacetCollector facetCounter = new NoDelegateFacetCollector(rb.req);
            for (int subIdx = 0; subIdx < leaves.size(); ++subIdx) {
                DocIdSet dis;
                LeafReaderContext subCtx = (LeafReaderContext)leaves.get(subIdx);
                SegmentChildren iter = new SegmentChildren(subCtx, dis = filter.getDocIdSet(subCtx, null), allParentsBitsDocSet);
                if (!iter.hasNext()) continue;
                facetCounter.doSetNextReader(subCtx);
                facetCounter.countFacets(iter);
            }
            facetCounter.finish();
            rb.req.getContext().put("blockJoinFacetCollector", (Object)facetCounter);
            super.process(rb);
        }
    }

    private static final class NoDelegateFacetCollector
    extends BlockJoinFacetCollector {
        private NoDelegateFacetCollector(SolrQueryRequest req) throws IOException {
            super(req);
            this.setDelegate(new Collector(){

                public boolean needsScores() {
                    return false;
                }

                public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
                    return null;
                }
            });
        }
    }

    private static final class SegmentChildren
    implements BlockJoinFieldFacetAccumulator.AggregatableDocIter {
        private final BitDocSet allParentsBitsDocSet;
        private int nextDoc = Integer.MAX_VALUE;
        private DocIdSetIterator disi;
        private int currentParent = -1;
        final LeafReaderContext segment;
        final DocIdSet childrenMatches;

        private SegmentChildren(LeafReaderContext subCtx, DocIdSet dis, BitDocSet allParentsBitsDocSet) {
            this.allParentsBitsDocSet = allParentsBitsDocSet;
            this.childrenMatches = dis;
            this.segment = subCtx;
            this.reset();
        }

        @Override
        public Integer next() {
            return this.nextDoc();
        }

        @Override
        public boolean hasNext() {
            return this.nextDoc != Integer.MAX_VALUE;
        }

        @Override
        public float score() {
            return 0.0f;
        }

        @Override
        public int nextDoc() {
            int lastDoc = this.nextDoc;
            assert (this.nextDoc != Integer.MAX_VALUE);
            if (lastDoc > this.currentParent) {
                this.currentParent = this.allParentsBitsDocSet.getBits().nextSetBit(lastDoc + this.segment.docBase) - this.segment.docBase;
            }
            try {
                this.nextDoc = this.disi.nextDoc();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return lastDoc;
        }

        @Override
        public void reset() {
            this.currentParent = -1;
            try {
                this.disi = this.childrenMatches.iterator();
                this.nextDoc = this.disi != null ? this.disi.nextDoc() : Integer.MAX_VALUE;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getAggKey() {
            return this.currentParent;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("for" + this);
        }
    }
}

