/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.ScoreModeParser;

public class BlockJoinParentQParser
extends QParser {
    public String CACHE_NAME = "perSegFilter";

    protected String getParentFilterLocalParamName() {
        return "which";
    }

    BlockJoinParentQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        String filter = this.localParams.get(this.getParentFilterLocalParamName());
        String scoreMode = this.localParams.get("score", ScoreMode.None.name());
        QParser parentParser = this.subQuery(filter, null);
        Query parentQ = parentParser.getQuery();
        String queryText = this.localParams.get("v");
        if (queryText == null || queryText.length() == 0) {
            SolrConstantScoreQuery wrapped = new SolrConstantScoreQuery(this.getFilter(parentQ));
            wrapped.setCache(false);
            return wrapped;
        }
        QParser childrenParser = this.subQuery(queryText, null);
        Query childrenQuery = childrenParser.getQuery();
        return this.createQuery(parentQ, childrenQuery, scoreMode);
    }

    protected Query createQuery(Query parentList, Query query, String scoreMode) throws SyntaxError {
        return new AllParentsAware(query, this.getFilter((Query)parentList).filter, ScoreModeParser.parse(scoreMode), parentList);
    }

    BitDocIdSetFilterWrapper getFilter(Query parentList) {
        BitDocIdSetFilterWrapper result;
        SolrCache parentCache = this.req.getSearcher().getCache(this.CACHE_NAME);
        Filter filter = null;
        if (parentCache != null) {
            filter = (Filter)parentCache.get(parentList);
        }
        if (filter instanceof BitDocIdSetFilterWrapper) {
            result = (BitDocIdSetFilterWrapper)filter;
        } else {
            result = new BitDocIdSetFilterWrapper(this.createParentFilter(parentList));
            if (parentCache != null) {
                parentCache.put(parentList, result);
            }
        }
        return result;
    }

    private BitSetProducer createParentFilter(Query parentQ) {
        return new QueryBitSetProducer(parentQ);
    }

    static class BitDocIdSetFilterWrapper
    extends Filter {
        final BitSetProducer filter;

        BitDocIdSetFilterWrapper(BitSetProducer filter) {
            this.filter = filter;
        }

        public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
            BitSet set = this.filter.getBitSet(context);
            if (set == null) {
                return null;
            }
            return BitsFilteredDocIdSet.wrap((DocIdSet)new BitDocIdSet(set), (Bits)acceptDocs);
        }

        public String toString(String field) {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.filter + ")";
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return this.filter.equals(((BitDocIdSetFilterWrapper)((Object)obj)).filter);
        }

        public int hashCode() {
            return 31 * super.hashCode() + this.filter.hashCode();
        }
    }

    static final class AllParentsAware
    extends ToParentBlockJoinQuery {
        private final Query parentQuery;

        private AllParentsAware(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode, Query parentList) {
            super(childQuery, parentsFilter, scoreMode);
            this.parentQuery = parentList;
        }

        public Query getParentQuery() {
            return this.parentQuery;
        }
    }
}

