/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.solr.common.util.FastOutputStream;

public class MemOutputStream
extends FastOutputStream {
    public List<byte[]> buffers = new LinkedList<byte[]>();

    public MemOutputStream(byte[] tempBuffer) {
        super(null, tempBuffer, 0);
    }

    @Override
    public void flush(byte[] arr, int offset, int len) throws IOException {
        if (arr == this.buf && offset == 0 && len == this.buf.length) {
            this.buffers.add(this.buf);
            this.buf = new byte[8192];
        } else if (len > 0) {
            byte[] newBuf = new byte[len];
            System.arraycopy(arr, offset, newBuf, 0, len);
            this.buffers.add(newBuf);
        }
    }

    public void writeAll(FastOutputStream fos) throws IOException {
        for (byte[] buffer : this.buffers) {
            fos.write(buffer);
        }
        if (this.pos > 0) {
            fos.write(this.buf, 0, this.pos);
        }
    }
}

