/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.index.IndexWriter;
import org.apache.solr.cloud.ActionThrottle;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrCoreState {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean closed = false;
    private final Object updateLock = new Object();
    private int solrCoreStateRefCnt = 1;

    public Object getUpdateLock() {
        return this.updateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increfSolrCoreState() {
        SolrCoreState solrCoreState = this;
        synchronized (solrCoreState) {
            if (this.solrCoreStateRefCnt == 0) {
                throw new IllegalStateException("IndexWriter has been closed");
            }
            ++this.solrCoreStateRefCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrefSolrCoreState(IndexWriterCloser closer) {
        boolean close = false;
        SolrCoreState solrCoreState = this;
        synchronized (solrCoreState) {
            --this.solrCoreStateRefCnt;
            assert (this.solrCoreStateRefCnt >= 0);
            if (this.solrCoreStateRefCnt == 0) {
                this.closed = true;
                close = true;
            }
        }
        if (close) {
            try {
                log.info("Closing SolrCoreState");
                this.close(closer);
            }
            catch (Exception e) {
                log.error("Error closing SolrCoreState", (Throwable)e);
            }
        }
        return close;
    }

    public abstract Lock getCommitLock();

    public abstract void newIndexWriter(SolrCore var1, boolean var2) throws IOException;

    public abstract void closeIndexWriter(SolrCore var1, boolean var2) throws IOException;

    public abstract void openIndexWriter(SolrCore var1) throws IOException;

    public abstract RefCounted<IndexWriter> getIndexWriter(SolrCore var1) throws IOException;

    public abstract void rollbackIndexWriter(SolrCore var1) throws IOException;

    public abstract DirectoryFactory getDirectoryFactory();

    public abstract void doRecovery(CoreContainer var1, CoreDescriptor var2);

    public abstract void cancelRecovery();

    public abstract void close(IndexWriterCloser var1);

    public abstract ActionThrottle getLeaderThrottle();

    public abstract boolean getLastReplicateIndexSuccess();

    public abstract void setLastReplicateIndexSuccess(boolean var1);

    public static interface IndexWriterCloser {
        public void closeWriter(IndexWriter var1) throws IOException;
    }
}

