/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class FieldNameMutatingUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private String sourcePattern;
    private String replacement;
    private Pattern pattern;

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new UpdateRequestProcessor(next){

            @Override
            public void processAdd(AddUpdateCommand cmd) throws IOException {
                SolrInputDocument doc = cmd.getSolrInputDocument();
                ArrayList<String> fieldNames = new ArrayList<String>(doc.getFieldNames());
                for (String fname : fieldNames) {
                    String newFieldName;
                    Matcher matcher = FieldNameMutatingUpdateProcessorFactory.this.pattern.matcher(fname);
                    if (!matcher.find() || (newFieldName = matcher.replaceAll(FieldNameMutatingUpdateProcessorFactory.this.replacement)).equals(fname)) continue;
                    SolrInputField old = doc.remove(fname);
                    old.setName(newFieldName);
                    doc.put(newFieldName, old);
                }
                super.processAdd(cmd);
            }

            @Override
            public void processDelete(DeleteUpdateCommand cmd) throws IOException {
                super.processDelete(cmd);
            }
        };
    }

    @Override
    public void init(NamedList args) {
        this.sourcePattern = (String)args.get("pattern");
        this.replacement = (String)args.get("replacement");
        if (this.sourcePattern == null || this.replacement == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'pattern' and 'replacement' are required values");
        }
        try {
            this.pattern = Pattern.compile(this.sourcePattern);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "invalid pattern " + this.sourcePattern);
        }
        super.init(args);
    }
}

