/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexpBoostProcessor
extends UpdateRequestProcessor {
    protected static final String INPUT_FIELD_PARAM = "inputField";
    protected static final String BOOST_FIELD_PARAM = "boostField";
    protected static final String BOOST_FILENAME_PARAM = "boostFilename";
    private static final String DEFAULT_INPUT_FIELDNAME = "url";
    private static final String DEFAULT_BOOST_FIELDNAME = "urlboost";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean enabled = true;
    private String inputFieldname = "url";
    private String boostFieldname = "urlboost";
    private String boostFilename;
    private List<BoostEntry> boostEntries = new ArrayList<BoostEntry>();
    private static final String BOOST_ENTRIES_CACHE_KEY = "boost-entries";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegexpBoostProcessor(SolrParams parameters, SolrQueryRequest request, SolrQueryResponse response, UpdateRequestProcessor nextProcessor, Map<Object, Object> sharedObjectCache) {
        super(nextProcessor);
        this.initParameters(parameters);
        if (this.boostFilename == null) {
            log.warn("Null boost filename.  Disabling processor.");
            this.setEnabled(false);
        }
        if (!this.isEnabled()) {
            return;
        }
        try {
            Map<Object, Object> map = sharedObjectCache;
            synchronized (map) {
                List<BoostEntry> cachedBoostEntries = (List<BoostEntry>)sharedObjectCache.get(BOOST_ENTRIES_CACHE_KEY);
                if (cachedBoostEntries == null) {
                    log.debug("No pre-cached boost entry list found, initializing new");
                    InputStream is = request.getCore().getResourceLoader().openResource(this.boostFilename);
                    cachedBoostEntries = this.initBoostEntries(is);
                    sharedObjectCache.put(BOOST_ENTRIES_CACHE_KEY, cachedBoostEntries);
                } else if (log.isDebugEnabled()) {
                    log.debug("Using cached boost entry list with " + cachedBoostEntries.size() + " elements.");
                }
                this.boostEntries = cachedBoostEntries;
            }
        }
        catch (IOException ioe) {
            log.warn("IOException while initializing boost entries from file " + this.boostFilename, (Throwable)ioe);
        }
    }

    private void initParameters(SolrParams parameters) {
        if (parameters != null) {
            this.setEnabled(parameters.getBool("enabled", true));
            this.inputFieldname = parameters.get(INPUT_FIELD_PARAM, DEFAULT_INPUT_FIELDNAME);
            this.boostFieldname = parameters.get(BOOST_FIELD_PARAM, DEFAULT_BOOST_FIELDNAME);
            this.boostFilename = parameters.get(BOOST_FILENAME_PARAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BoostEntry> initBoostEntries(InputStream is) throws IOException {
        ArrayList<BoostEntry> newBoostEntries = new ArrayList<BoostEntry>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll("\\s+#.*$", "");
                if ((line = line.replaceAll("^#.*$", "")).trim().length() == 0) continue;
                String[] fields = line.split("\\s+");
                if (fields.length == 2) {
                    String regexp = fields[0];
                    String boost = fields[1];
                    newBoostEntries.add(new BoostEntry(Pattern.compile(regexp), Double.parseDouble(boost)));
                    log.debug("Read regexp " + regexp + " with boost " + boost);
                    continue;
                }
                log.warn("Malformed config input line: " + line + " (expected 2 fields, got " + fields.length + " fields).  Skipping entry.");
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return newBoostEntries;
    }

    @Override
    public void processAdd(AddUpdateCommand command) throws IOException {
        if (this.isEnabled()) {
            this.processBoost(command);
        }
        super.processAdd(command);
    }

    public void processBoost(AddUpdateCommand command) {
        SolrInputDocument document = command.getSolrInputDocument();
        if (document.containsKey(this.inputFieldname)) {
            String value = (String)document.getFieldValue(this.inputFieldname);
            double boost = 1.0;
            for (BoostEntry boostEntry : this.boostEntries) {
                if (!boostEntry.getPattern().matcher(value).matches()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Pattern match " + boostEntry.getPattern().pattern() + " for " + value);
                }
                boost = boostEntry.getBoost() * 1000.0 * (boost * 1000.0) / 1000000.0;
            }
            document.setField(this.boostFieldname, boost);
            if (log.isDebugEnabled()) {
                log.debug("Value " + boost + ", applied to field " + this.boostFieldname);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private static class BoostEntry {
        private Pattern pattern;
        private double boost;

        public BoostEntry(Pattern pattern, double d) {
            this.pattern = pattern;
            this.boost = d;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public double getBoost() {
            return this.boost;
        }
    }
}

