/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Pair;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInjection {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern ENABLED_PERCENT = Pattern.compile("(true|false)(?:\\:(\\d+))?$", 2);
    private static final Random RANDOM;
    public static String nonGracefullClose;
    public static String failReplicaRequests;
    public static String failUpdateRequests;
    public static String nonExistentCoreExceptionAfterUnload;
    public static String updateLogReplayRandomPause;
    public static String updateRandomPause;
    public static String randomDelayInCoreCreation;
    public static int randomDelayMaxInCoreCreationInSec;
    private static Set<Timer> timers;

    public static void reset() {
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        nonExistentCoreExceptionAfterUnload = null;
        updateLogReplayRandomPause = null;
        updateRandomPause = null;
        randomDelayInCoreCreation = null;
        for (Timer timer : timers) {
            timer.cancel();
        }
    }

    public static boolean injectRandomDelayInCoreCreation() {
        if (randomDelayInCoreCreation != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(randomDelayInCoreCreation);
            boolean enabled = pair.getKey();
            int chanceIn100 = pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                int delay = RANDOM.nextInt(randomDelayMaxInCoreCreationInSec);
                log.info("Inject random core creation delay of {}s", (Object)delay);
                try {
                    Thread.sleep(delay * 1000);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    public static boolean injectNonGracefullClose(CoreContainer cc) {
        if (cc.isShutDown() && nonGracefullClose != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonGracefullClose);
            boolean enabled = pair.getKey();
            int chanceIn100 = pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                if (RANDOM.nextBoolean()) {
                    throw new TestShutdownFailError("Test exception for non graceful close");
                }
                final Thread cthread = Thread.currentThread();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(RANDOM.nextInt(1000));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        cthread.interrupt();
                        timers.remove(this);
                        this.cancel();
                    }
                };
                Timer timer = new Timer();
                timers.add(timer);
                timer.schedule(task, RANDOM.nextInt(500));
            }
        }
        return true;
    }

    public static boolean injectFailReplicaRequests() {
        if (failReplicaRequests != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failReplicaRequests);
            boolean enabled = pair.getKey();
            int chanceIn100 = pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    public static boolean injectFailUpdateRequests() {
        if (failUpdateRequests != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(failUpdateRequests);
            boolean enabled = pair.getKey();
            int chanceIn100 = pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Random test update fail");
            }
        }
        return true;
    }

    public static boolean injectNonExistentCoreExceptionAfterUnload(String cname) {
        if (nonExistentCoreExceptionAfterUnload != null) {
            Pair<Boolean, Integer> pair = TestInjection.parseValue(nonExistentCoreExceptionAfterUnload);
            boolean enabled = pair.getKey();
            int chanceIn100 = pair.getValue();
            if (enabled && RANDOM.nextInt(100) >= 100 - chanceIn100) {
                throw new NonExistentCoreException("Core not found to unload: " + cname);
            }
        }
        return true;
    }

    private static Pair<Boolean, Integer> parseValue(String raw) {
        Matcher m = ENABLED_PERCENT.matcher(raw);
        if (!m.matches()) {
            throw new RuntimeException("No match, probably bad syntax: " + raw);
        }
        String val = m.group(1);
        String percent = "100";
        if (m.groupCount() == 2) {
            percent = m.group(2);
        }
        return new Pair<Boolean, Integer>(Boolean.parseBoolean(val), Integer.parseInt(percent));
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
        nonGracefullClose = null;
        failReplicaRequests = null;
        failUpdateRequests = null;
        nonExistentCoreExceptionAfterUnload = null;
        updateLogReplayRandomPause = null;
        updateRandomPause = null;
        randomDelayInCoreCreation = null;
        randomDelayMaxInCoreCreationInSec = 10;
        timers = Collections.synchronizedSet(new HashSet());
    }

    public static class TestShutdownFailError
    extends OutOfMemoryError {
        public TestShutdownFailError(String msg) {
            super(msg);
        }
    }
}

