/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;

public class OverseerSolrResponseSerializer {
    public static byte[] serialize(OverseerSolrResponse responseObject) {
        Objects.requireNonNull(responseObject);
        if (OverseerSolrResponseSerializer.useUnsafeSerialization()) {
            return SolrResponse.serializable(responseObject);
        }
        try {
            return IOUtils.toByteArray((InputStream)Utils.toJavabin(responseObject.getResponse()));
        }
        catch (IOException | RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception serializing response to Javabin", (Throwable)e);
        }
    }

    static boolean useUnsafeSerialization() {
        String useUnsafeOverseerResponse = System.getProperty("solr.useUnsafeOverseerResponse");
        return useUnsafeOverseerResponse != null && "true".equals(useUnsafeOverseerResponse);
    }

    static boolean useUnsafeDeserialization() {
        String useUnsafeOverseerResponse = System.getProperty("solr.useUnsafeOverseerResponse");
        return useUnsafeOverseerResponse != null && ("true".equals(useUnsafeOverseerResponse) || "deserialization".equals(useUnsafeOverseerResponse));
    }

    public static OverseerSolrResponse deserialize(byte[] responseBytes) {
        Objects.requireNonNull(responseBytes);
        try {
            NamedList response = (NamedList)Utils.fromJavabin(responseBytes);
            return new OverseerSolrResponse(response);
        }
        catch (IOException | RuntimeException e) {
            if (OverseerSolrResponseSerializer.useUnsafeDeserialization()) {
                return (OverseerSolrResponse)SolrResponse.deserialize(responseBytes);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception deserializing response from Javabin", (Throwable)e);
        }
    }
}

