/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.data.Stat;

public class RefreshCollectionMessage
implements Overseer.Message {
    public final String collection;

    public RefreshCollectionMessage(String collection) {
        this.collection = collection;
    }

    @Override
    public ClusterState run(ClusterState clusterState, Overseer overseer) throws Exception {
        Stat stat = overseer.getZkStateReader().getZkClient().exists(ZkStateReader.getCollectionPath(this.collection), null, true);
        if (stat == null) {
            return clusterState.copyWith(this.collection, null);
        }
        DocCollection coll = clusterState.getCollectionOrNull(this.collection);
        if (coll != null && !coll.isModified(stat.getVersion(), stat.getCversion())) {
            return clusterState;
        }
        coll = ZkStateReader.getCollectionLive(overseer.getZkStateReader(), this.collection);
        return clusterState.copyWith(this.collection, coll);
    }
}

