/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.Map;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionProperties;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.LocalSolrQueryRequest;

abstract class AliasCmd
implements OverseerCollectionMessageHandler.Cmd {
    final OverseerCollectionMessageHandler ocmh;

    AliasCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    static NamedList createCollectionAndWait(ClusterState clusterState, String aliasName, Map<String, String> aliasMetadata, String createCollName, OverseerCollectionMessageHandler ocmh) throws Exception {
        NamedList results;
        block5: {
            ModifiableSolrParams createReqParams = new ModifiableSolrParams();
            for (Map.Entry<String, String> e : aliasMetadata.entrySet()) {
                if (!e.getKey().startsWith("create-collection.")) continue;
                createReqParams.set(e.getKey().substring("create-collection.".length()), e.getValue());
            }
            if (createReqParams.get("collection.configName") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We require an explicit collection.configName");
            }
            createReqParams.set("name", createCollName);
            Map<String, Object> createMsgMap = CollectionsHandler.CollectionOperation.CREATE_OP.execute(new LocalSolrQueryRequest(null, createReqParams), null, ocmh.overseer.getCoreContainer().getCollectionsHandler());
            createMsgMap.put("operation", "create");
            results = new NamedList();
            try {
                ocmh.commandMap.get((Object)CollectionParams.CollectionAction.CREATE).call(clusterState, new ZkNodeProps(createMsgMap), results);
            }
            catch (SolrException e) {
                if (e.getMessage().contains("collection already exists")) break block5;
                throw e;
            }
        }
        CollectionsHandler.waitForActiveCollection(createCollName, ocmh.overseer.getCoreContainer(), new OverseerSolrResponse(results));
        CollectionProperties collectionProperties = new CollectionProperties(ocmh.zkStateReader.getZkClient());
        collectionProperties.setCollectionProperty(createCollName, "routedAliasName", aliasName);
        while (!ocmh.zkStateReader.getCollectionProperties(createCollName, 1000L).containsKey("routedAliasName")) {
            Thread.sleep(50L);
        }
        return results;
    }
}

