/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilizeNodeCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public UtilizeNodeCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.ocmh.checkRequired(message, "node");
        String nodeName = message.getStr("node");
        String async = message.getStr("async");
        AutoScalingConfig autoScalingConfig = this.ocmh.overseer.getSolrCloudManager().getDistribStateManager().getAutoScalingConfig();
        ArrayList<ZkNodeProps> requests = new ArrayList<ZkNodeProps>();
        List<Suggester.SuggestionInfo> suggestions = PolicyHelper.getSuggestions(autoScalingConfig, this.ocmh.overseer.getSolrCloudManager());
        for (Suggester.SuggestionInfo suggestionInfo : suggestions) {
            String targetNode;
            if (log.isInfoEnabled()) {
                log.info("op: {}", (Object)suggestionInfo.getOperation());
            }
            String coll = null;
            List<String> pieces = StrUtils.splitSmart(suggestionInfo.getOperation().getPath(), '/');
            if (pieces.size() <= 1) continue;
            coll = pieces.get(2);
            log.info("coll: {}", (Object)coll);
            if (!(suggestionInfo.getOperation() instanceof V2Request) || !Objects.equals(targetNode = (String)Utils.getObjectByPath((Object)suggestionInfo.getOperation(), true, "command/move-replica/targetNode"), nodeName)) continue;
            String replica = (String)Utils.getObjectByPath((Object)suggestionInfo.getOperation(), true, "command/move-replica/replica");
            requests.add(new ZkNodeProps("collection", coll, "targetNode", targetNode, "async", async, "replica", replica));
        }
        this.executeAll(requests);
        PolicyHelper.SessionWrapper sessionWrapper = PolicyHelper.getSession(this.ocmh.overseer.getSolrCloudManager());
        Policy.Session session = sessionWrapper.get();
        Suggester initialsuggester = session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.TARGET_NODE, nodeName);
        Suggester suggester = null;
        while (true) {
            suggester = session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.TARGET_NODE, nodeName);
            SolrRequest request = suggester.getSuggestion();
            if (requests.size() > 10) {
                log.info("too_many_suggestions");
                PolicyHelper.logState(this.ocmh.overseer.getSolrCloudManager(), initialsuggester);
                break;
            }
            log.info("SUGGESTION: {}", (Object)request);
            if (request == null) break;
            session = suggester.getSession();
            requests.add(new ZkNodeProps("collection", request.getParams().get("collection"), "targetNode", request.getParams().get("targetNode"), "replica", request.getParams().get("replica"), "async", request.getParams().get("async")));
        }
        if (log.isInfoEnabled()) {
            log.info("total_suggestions: {}", (Object)requests.size());
        }
        if (requests.size() == 0) {
            PolicyHelper.logState(this.ocmh.overseer.getSolrCloudManager(), initialsuggester);
        }
        sessionWrapper.returnSession(session);
        try {
            this.executeAll(requests);
        }
        finally {
            sessionWrapper.release();
        }
    }

    private void executeAll(List<ZkNodeProps> requests) throws Exception {
        if (requests.isEmpty()) {
            return;
        }
        for (ZkNodeProps props : requests) {
            NamedList result = new NamedList();
            this.ocmh.commandMap.get((Object)CollectionParams.CollectionAction.MOVEREPLICA).call(this.ocmh.overseer.getSolrCloudManager().getClusterStateProvider().getClusterState(), props, result);
        }
        requests.clear();
    }
}

