/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.NotEmptyException;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerActionBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactiveMarkersPlanAction
extends TriggerActionBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String TTL_PROP = "ttl";
    public static final int DEFAULT_TTL_SECONDS = 172800;
    private int cleanupTTL;

    public InactiveMarkersPlanAction() {
        TriggerUtils.validProperties(this.validProperties, TTL_PROP);
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        String cleanupStr = String.valueOf(properties.getOrDefault(TTL_PROP, String.valueOf(172800)));
        try {
            this.cleanupTTL = Integer.parseInt(cleanupStr);
        }
        catch (Exception e) {
            throw new TriggerValidationException(this.getName(), TTL_PROP, "invalid value '" + cleanupStr + "': " + e.toString());
        }
        if (this.cleanupTTL < 0) {
            throw new TriggerValidationException(this.getName(), TTL_PROP, "invalid value '" + cleanupStr + "', should be > 0. ");
        }
    }

    @Override
    public void process(TriggerEvent event, ActionContext context) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("-- {} cleaning markers", (Object)this.getName());
        }
        long currentTimeNs = this.cloudManager.getTimeSource().getEpochTimeNs();
        LinkedHashMap<String, TreeSet<String>> results = new LinkedHashMap<String, TreeSet<String>>();
        TreeSet<String> cleanedUp = new TreeSet<String>();
        this.cleanupMarkers("/autoscaling/nodeAdded", currentTimeNs, cleanedUp);
        if (!cleanedUp.isEmpty()) {
            results.put("nodeAdded", cleanedUp);
            cleanedUp = new TreeSet();
        }
        this.cleanupMarkers("/autoscaling/nodeLost", currentTimeNs, cleanedUp);
        if (!cleanedUp.isEmpty()) {
            results.put("nodeLost", cleanedUp);
        }
        if (!results.isEmpty()) {
            context.getProperties().put(this.getName(), results);
        }
    }

    private void cleanupMarkers(String path, long currentTimeNs, Set<String> cleanedUp) throws Exception {
        DistribStateManager stateManager = this.cloudManager.getDistribStateManager();
        if (!stateManager.hasData(path)) {
            return;
        }
        List<String> markers = stateManager.listData(path);
        markers.forEach(m -> {
            block9: {
                String markerPath = path + "/" + m;
                try {
                    Map<String, Object> payload = Utils.getJson(stateManager, markerPath);
                    if (payload.isEmpty()) {
                        log.trace(" -- ignore {}: either missing or unsupported format", (Object)markerPath);
                        return;
                    }
                    boolean activeMarker = payload.getOrDefault("state", "active").equals("active");
                    long timestamp = ((Number)payload.get("timestamp")).longValue();
                    long delta = TimeUnit.NANOSECONDS.toSeconds(currentTimeNs - timestamp);
                    if (delta > (long)this.cleanupTTL || !activeMarker) {
                        try {
                            stateManager.removeData(markerPath, -1);
                            log.trace(" -- remove {}, delta={}, ttl={}, active={}", new Object[]{markerPath, delta, this.cleanupTTL, activeMarker});
                            cleanedUp.add((String)m);
                            break block9;
                        }
                        catch (NoSuchElementException nse) {
                            return;
                        }
                        catch (BadVersionException be) {
                            throw new RuntimeException("should never happen", be);
                        }
                        catch (NotEmptyException ne) {
                            log.error("Marker znode should be empty but it's not! Ignoring {} ({})", (Object)markerPath, (Object)ne);
                            break block9;
                        }
                    }
                    log.trace(" -- keep {}, delta={}, ttl={}, active={}", new Object[]{markerPath, delta, this.cleanupTTL, activeMarker});
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (IOException | KeeperException e) {
                    log.warn("Could not cleanup marker at {}, skipping... ", (Object)markerPath, (Object)e);
                }
            }
        });
    }
}

