/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.solr.client.solrj.cloud.DistributedQueue;
import org.apache.solr.client.solrj.cloud.DistributedQueueFactory;
import org.apache.solr.cloud.Stats;
import org.apache.solr.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimDistributedQueueFactory
implements DistributedQueueFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Map<String, SimDistributedQueue> queues = new ConcurrentHashMap<String, SimDistributedQueue>();

    @Override
    public DistributedQueue makeQueue(String path) throws IOException {
        return this.queues.computeIfAbsent(path, p -> new SimDistributedQueue(path));
    }

    @Override
    public void removeQueue(String path) throws IOException {
        this.queues.remove(path);
    }

    public static class SimDistributedQueue
    implements DistributedQueue {
        private final Queue<Pair<String, byte[]>> queue = new ConcurrentLinkedQueue<Pair<String, byte[]>>();
        private final ReentrantLock updateLock = new ReentrantLock();
        private final Condition changed = this.updateLock.newCondition();
        private final Stats stats = new Stats();
        private final String dir;
        private int seq = 0;

        public SimDistributedQueue(String dir) {
            this.dir = dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] peek() throws Exception {
            Timer.Context time = this.stats.time(this.dir + "_peek");
            try {
                Pair<String, byte[]> pair = this.queue.peek();
                byte[] byArray = pair != null ? pair.second() : null;
                return byArray;
            }
            finally {
                time.stop();
            }
        }

        @Override
        public byte[] peek(boolean block) throws Exception {
            return block ? this.peek(Long.MAX_VALUE) : this.peek();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] peek(long wait) throws Exception {
            Timer.Context time = wait == Long.MAX_VALUE ? this.stats.time(this.dir + "_peek_wait_forever") : this.stats.time(this.dir + "_peek_wait" + wait);
            try {
                Pair<String, byte[]> pair = this.peekInternal(wait);
                byte[] byArray = pair != null ? pair.second() : null;
                return byArray;
            }
            finally {
                time.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Pair<String, byte[]> peekInternal(long wait) throws Exception {
            Preconditions.checkArgument((wait > 0L ? 1 : 0) != 0);
            long waitNanos = TimeUnit.MILLISECONDS.toNanos(wait);
            this.updateLock.lockInterruptibly();
            try {
                while (waitNanos > 0L) {
                    Pair<String, byte[]> pair = this.queue.peek();
                    if (pair != null) {
                        Pair<String, byte[]> pair2 = pair;
                        return pair2;
                    }
                    if ((waitNanos = this.changed.awaitNanos(waitNanos)) >= 0L) continue;
                    Pair<String, byte[]> pair3 = null;
                    return pair3;
                }
            }
            finally {
                this.updateLock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] poll() throws Exception {
            Timer.Context time = this.stats.time(this.dir + "_poll");
            this.updateLock.lockInterruptibly();
            try {
                Pair<String, byte[]> pair = this.queue.poll();
                if (pair != null) {
                    this.changed.signalAll();
                    byte[] byArray = pair.second();
                    return byArray;
                }
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.updateLock.unlock();
                time.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] remove() throws Exception {
            Timer.Context time = this.stats.time(this.dir + "_remove");
            this.updateLock.lockInterruptibly();
            try {
                byte[] res = this.queue.remove().second();
                this.changed.signalAll();
                byte[] byArray = res;
                return byArray;
            }
            finally {
                this.updateLock.unlock();
                time.stop();
            }
        }

        @Override
        public byte[] take() throws Exception {
            Timer.Context timer = this.stats.time(this.dir + "_take");
            this.updateLock.lockInterruptibly();
            try {
                while (true) {
                    byte[] result;
                    if ((result = this.poll()) != null) {
                        byte[] byArray = result;
                        return byArray;
                    }
                    this.changed.await();
                }
            }
            finally {
                this.updateLock.unlock();
                timer.stop();
            }
        }

        @Override
        public void offer(byte[] data) throws Exception {
            Timer.Context time = this.stats.time(this.dir + "_offer");
            this.updateLock.lockInterruptibly();
            try {
                this.queue.offer(new Pair<String, byte[]>(String.format(Locale.ROOT, "qn-%010d", this.seq), data));
                ++this.seq;
                if (log.isTraceEnabled()) {
                    log.trace("=== offer {}", (Object)System.nanoTime());
                }
                this.changed.signalAll();
            }
            finally {
                this.updateLock.unlock();
                time.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Pair<String, byte[]>> peekElements(int max, long waitMillis, Predicate<String> acceptFilter) throws Exception {
            this.updateLock.lockInterruptibly();
            try {
                LinkedList<Pair<String, byte[]>> res = new LinkedList<Pair<String, byte[]>>();
                int maximum = max < 0 ? Integer.MAX_VALUE : max;
                AtomicReference pairRef = new AtomicReference();
                this.queue.forEach(pair -> {
                    if (acceptFilter != null && !acceptFilter.test((String)pair.first())) {
                        return;
                    }
                    if (res.size() < maximum) {
                        pairRef.set(pair);
                        res.add((Pair<String, byte[]>)pair);
                    }
                });
                if (res.size() < maximum && waitMillis > 0L) {
                    long waitNanos = TimeUnit.MILLISECONDS.toNanos(waitMillis);
                    if ((waitNanos = this.changed.awaitNanos(waitNanos)) < 0L) {
                        LinkedList<Pair<String, byte[]>> linkedList = res;
                        return linkedList;
                    }
                    AtomicBoolean seen = new AtomicBoolean(false);
                    this.queue.forEach(pair -> {
                        if (!seen.get()) {
                            if (pairRef.get() == null) {
                                seen.set(true);
                            } else if (((String)((Pair)pairRef.get()).first()).equals(pair.first())) {
                                seen.set(true);
                                return;
                            }
                        }
                        if (!seen.get()) {
                            return;
                        }
                        if (!acceptFilter.test((String)pair.first())) {
                            return;
                        }
                        if (res.size() >= maximum) {
                            return;
                        }
                        res.add((Pair<String, byte[]>)pair);
                        pairRef.set(pair);
                    });
                }
                LinkedList<Pair<String, byte[]>> linkedList = res;
                return linkedList;
            }
            finally {
                this.updateLock.unlock();
            }
        }

        public Stats getZkStats() {
            return this.stats;
        }

        @Override
        public Map<String, Object> getStats() {
            if (this.stats == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("queueLength", this.stats.getQueueLength());
            HashMap statsMap = new HashMap();
            res.put("stats", statsMap);
            this.stats.getStats().forEach((op, stat) -> {
                HashMap<String, Serializable> statMap = new HashMap<String, Serializable>();
                statMap.put("success", Integer.valueOf(stat.success.get()));
                statMap.put("errors", Integer.valueOf(stat.errors.get()));
                ArrayList failed = new ArrayList(stat.failureDetails.size());
                statMap.put("failureDetails", failed);
                stat.failureDetails.forEach(failedOp -> {
                    HashMap<String, Object> fo = new HashMap<String, Object>();
                    fo.put("req", failedOp.req);
                    fo.put("resp", failedOp.resp);
                });
                statsMap.put(op, statMap);
            });
            return res;
        }
    }
}

