/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.TransientSolrCoreCache;
import org.apache.solr.core.TransientSolrCoreCacheFactory;
import org.apache.solr.logging.MDCLoggingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrCores {
    private static Object modifyLock = new Object();
    private final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    private final Map<String, CoreDescriptor> residentDescriptors = new LinkedHashMap<String, CoreDescriptor>();
    private final CoreContainer container;
    private Set<String> currentlyLoadingCores = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> pendingCoreOps = new HashSet<String>();
    private static final List<SolrCore> pendingCloses = new ArrayList<SolrCore>();
    private TransientSolrCoreCacheFactory transientSolrCoreCacheFactory;

    SolrCores(CoreContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCoreDescriptor(CoreDescriptor p) {
        Object object = modifyLock;
        synchronized (object) {
            if (p.isTransient()) {
                this.getTransientCacheHandler().addTransientDescriptor(p.getName(), p);
            } else {
                this.residentDescriptors.put(p.getName(), p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCoreDescriptor(CoreDescriptor p) {
        Object object = modifyLock;
        synchronized (object) {
            if (p.isTransient()) {
                this.getTransientCacheHandler().removeTransientDescriptor(p.getName());
            } else {
                this.residentDescriptors.remove(p.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(SolrResourceLoader loader) {
        Object object = modifyLock;
        synchronized (object) {
            this.transientSolrCoreCacheFactory = TransientSolrCoreCacheFactory.newInstance(loader, this.container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.waitForLoadingCoresToFinish(30000L);
        ArrayList<SolrCore> coreList = new ArrayList<SolrCore>();
        Object object = modifyLock;
        synchronized (object) {
            if (this.transientSolrCoreCacheFactory != null) {
                this.getTransientCacheHandler().close();
            }
        }
        do {
            coreList.clear();
            object = modifyLock;
            synchronized (object) {
                coreList.addAll(this.cores.values());
                this.cores.clear();
                if (this.transientSolrCoreCacheFactory != null) {
                    coreList.addAll(this.getTransientCacheHandler().prepareForShutdown());
                }
                coreList.addAll(pendingCloses);
                pendingCloses.clear();
            }
            ExecutorService coreCloseExecutor = ExecutorUtil.newMDCAwareFixedThreadPool(Integer.MAX_VALUE, new SolrNamedThreadFactory("coreCloseExecutor"));
            try {
                for (SolrCore core : coreList) {
                    coreCloseExecutor.submit(() -> {
                        MDCLoggingContext.setCore(core);
                        try {
                            core.close();
                        }
                        catch (Throwable e) {
                            SolrException.log(log, "Error shutting down core", e);
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                        }
                        finally {
                            MDCLoggingContext.clear();
                        }
                        return core;
                    });
                }
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination(coreCloseExecutor);
            }
        } while (coreList.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putCore(CoreDescriptor cd, SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            this.addCoreDescriptor(cd);
            if (cd.isTransient()) {
                return this.getTransientCacheHandler().addCore(cd.getName(), core);
            }
            return this.cores.put(cd.getName(), core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SolrCore> getCores() {
        Object object = modifyLock;
        synchronized (object) {
            return new ArrayList<SolrCore>(this.cores.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getLoadedCoreNames() {
        Object object = modifyLock;
        synchronized (object) {
            return SolrCores.distinctSetsUnion(this.cores.keySet(), this.getTransientCacheHandler().getLoadedCoreNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllCoreNames() {
        Object object = modifyLock;
        synchronized (object) {
            return SolrCores.distinctSetsUnion(this.residentDescriptors.keySet(), this.getTransientCacheHandler().getAllCoreNames());
        }
    }

    private static <T> List<T> distinctSetsUnion(Set<T> set1, Set<T> set2) {
        assert (SolrCores.areSetsDistinct(set1, set2));
        ArrayList<T> union = new ArrayList<T>(set1.size() + set2.size());
        union.addAll(set1);
        union.addAll(set2);
        return union;
    }

    private static <T> boolean areSetsDistinct(Set<T> set1, Set<T> set2) {
        return set1.stream().noneMatch(set2::contains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumLoadedPermanentCores() {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumLoadedTransientCores() {
        Object object = modifyLock;
        synchronized (object) {
            return this.getTransientCacheHandler().getLoadedCoreNames().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumUnloadedCores() {
        Object object = modifyLock;
        synchronized (object) {
            assert (SolrCores.areSetsDistinct(this.residentDescriptors.keySet(), this.getTransientCacheHandler().getAllCoreNames()));
            return this.getTransientCacheHandler().getAllCoreNames().size() - this.getTransientCacheHandler().getLoadedCoreNames().size() + this.residentDescriptors.size() - this.cores.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumAllCores() {
        Object object = modifyLock;
        synchronized (object) {
            assert (SolrCores.areSetsDistinct(this.residentDescriptors.keySet(), this.getTransientCacheHandler().getAllCoreNames()));
            return this.residentDescriptors.size() + this.getTransientCacheHandler().getAllCoreNames().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolrCore getCore(String name) {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swap(String n0, String n1) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null && (c0 = this.container.getCore(n0)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null && (c1 = this.container.getCore(n1)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            CoreDescriptor cd1 = c1.getCoreDescriptor();
            this.addCoreDescriptor(new CoreDescriptor(n1, c0.getCoreDescriptor()));
            this.addCoreDescriptor(new CoreDescriptor(n0, cd1));
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c1.setName(n0);
            this.container.getMetricManager().swapRegistries(c0.getCoreMetricManager().getRegistryName(), c1.getCoreMetricManager().getRegistryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore remove(String name) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore ret = this.cores.remove(name);
            if (ret == null) {
                ret = this.getTransientCacheHandler().removeCore(name);
            }
            return ret;
        }
    }

    SolrCore getCoreFromAnyList(String name, boolean incRefCount) {
        return this.getCoreFromAnyList(name, incRefCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolrCore getCoreFromAnyList(String name, boolean incRefCount, UUID coreId) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore core = this.cores.get(name);
            if (core == null) {
                core = this.getTransientCacheHandler().getCore(name);
            }
            if (core != null && coreId != null && coreId != core.uniqueId) {
                return null;
            }
            if (core != null && incRefCount) {
                core.open();
            }
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoadedNotPendingClose(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.cores.containsKey(name)) {
                return true;
            }
            if (this.getTransientCacheHandler().containsCore(name)) {
                for (SolrCore core : pendingCloses) {
                    if (!core.getName().equals(name)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoaded(String name) {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.containsKey(name) || this.getTransientCacheHandler().containsCore(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        Object object = modifyLock;
        synchronized (object) {
            CoreDescriptor desc = this.residentDescriptors.get(cname);
            if (desc == null && (desc = this.getTransientCacheHandler().getTransientDescriptor(cname)) == null) {
                return null;
            }
            return new CoreDescriptor(cname, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore waitAddPendingCoreOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            boolean pending;
            do {
                if (!(pending = pendingCoreOps.contains(name))) {
                    for (SolrCore core : pendingCloses) {
                        if (!core.getName().equals(name)) continue;
                        pending = true;
                        break;
                    }
                }
                if (this.container.isShutDown()) {
                    return null;
                }
                if (!pending) continue;
                try {
                    modifyLock.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            } while (pending);
            if (!this.container.isShutDown()) {
                if (!pendingCoreOps.add(name)) {
                    log.warn("Replaced an entry in pendingCoreOps {}, we should not be doing this", (Object)name);
                }
                return this.getCoreFromAnyList(name, false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromPendingOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (!pendingCoreOps.remove(name)) {
                log.warn("Tried to remove core {} from pendingCoreOps and it wasn't there. ", (Object)name);
            }
            modifyLock.notifyAll();
        }
    }

    protected Object getModifyLock() {
        return modifyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreToClose() {
        Object object = modifyLock;
        synchronized (object) {
            for (SolrCore core : pendingCloses) {
                if (pendingCoreOps.contains(core.getName())) continue;
                pendingCoreOps.add(core.getName());
                pendingCloses.remove(core);
                return core;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDescriptor getCoreDescriptor(String coreName) {
        Object object = modifyLock;
        synchronized (object) {
            CoreDescriptor coreDescriptor = this.residentDescriptors.get(coreName);
            if (coreDescriptor != null) {
                return coreDescriptor;
            }
            return this.getTransientCacheHandler().getTransientDescriptor(coreName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoreDescriptor> getCoreDescriptors() {
        Object object = modifyLock;
        synchronized (object) {
            Collection<CoreDescriptor> transientCoreDescriptors = this.getTransientCacheHandler().getTransientDescriptors();
            ArrayList<CoreDescriptor> coreDescriptors = new ArrayList<CoreDescriptor>(this.residentDescriptors.size() + transientCoreDescriptors.size());
            coreDescriptors.addAll(this.residentDescriptors.values());
            coreDescriptors.addAll(transientCoreDescriptors);
            return coreDescriptors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCoreAsLoading(CoreDescriptor cd) {
        Object object = modifyLock;
        synchronized (object) {
            this.currentlyLoadingCores.add(cd.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCoreAsNotLoading(CoreDescriptor cd) {
        Object object = modifyLock;
        synchronized (object) {
            this.currentlyLoadingCores.remove(cd.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoadingCoresToFinish(long timeoutMs) {
        long time = System.nanoTime();
        long timeout = time + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS);
        Object object = modifyLock;
        synchronized (object) {
            while (!this.currentlyLoadingCores.isEmpty()) {
                try {
                    modifyLock.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (System.nanoTime() < timeout) continue;
                log.warn("Timed out waiting for SolrCores to finish loading.");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoadingCoreToFinish(String core, long timeoutMs) {
        long time = System.nanoTime();
        long timeout = time + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS);
        Object object = modifyLock;
        synchronized (object) {
            while (this.isCoreLoading(core)) {
                try {
                    modifyLock.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (System.nanoTime() < timeout) continue;
                log.warn("Timed out waiting for SolrCore, {},  to finish loading.", (Object)core);
                break;
            }
        }
    }

    public boolean isCoreLoading(String name) {
        return this.currentlyLoadingCores.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueCoreToClose(SolrCore coreToClose) {
        Object object = modifyLock;
        synchronized (object) {
            pendingCloses.add(coreToClose);
            modifyLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientSolrCoreCache getTransientCacheHandler() {
        Object object = modifyLock;
        synchronized (object) {
            if (this.transientSolrCoreCacheFactory == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getName() + " not loaded; call load() before using it");
            }
            return this.transientSolrCoreCacheFactory.getTransientSolrCoreCache();
        }
    }
}

