/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.ClusterPropInfo;
import org.apache.solr.client.solrj.request.beans.CreateConfigInfo;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class ClusterAPI {
    private final CollectionsHandler collectionsHandler;
    private final ConfigSetsHandler configSetsHandler;
    public final Commands commands = new Commands();
    public final ConfigSetCommands configSetCommands = new ConfigSetCommands();

    public ClusterAPI(CollectionsHandler ch, ConfigSetsHandler configSetsHandler) {
        this.collectionsHandler = ch;
        this.configSetsHandler = configSetsHandler;
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/aliases"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void aliases(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CollectionsHandler.CollectionOperation.LISTALIASES_OP.execute(req, rsp, this.getCoreContainer().getCollectionsHandler());
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/overseer"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getOverseerStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.getCoreContainer().getCollectionsHandler().handleRequestBody(ClusterAPI.wrapParams(req, "action", CollectionParams.CollectionAction.OVERSEERSTATUS.toString()), rsp);
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getCluster(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CollectionsHandler.CollectionOperation.LIST_OP.execute(req, rsp, this.getCoreContainer().getCollectionsHandler());
    }

    @EndPoint(method={SolrRequest.METHOD.DELETE}, path={"/cluster/command-status/{id}"}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public void deleteCommandStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ClusterAPI.wrapParams(req, "requestid", req.getPathTemplateValues().get("id"));
        CollectionsHandler.CollectionOperation.DELETESTATUS_OP.execute(req, rsp, this.collectionsHandler);
    }

    @EndPoint(method={SolrRequest.METHOD.DELETE}, path={"/cluster/configs/{name}"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void deleteConfigSet(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        req = ClusterAPI.wrapParams(req, "action", ConfigSetParams.ConfigSetAction.DELETE.toString(), "name", req.getPathTemplateValues().get("name"));
        this.configSetsHandler.handleRequestBody(req, rsp);
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/configs"}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void listConfigSet(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ConfigSetsHandler.ConfigSetOperation.LIST_OP.call(req, rsp, this.configSetsHandler);
    }

    @EndPoint(method={SolrRequest.METHOD.PUT}, path={"/cluster/configs/{name}"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void uploadConfigSet(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        req = ClusterAPI.wrapParams(req, "action", ConfigSetParams.ConfigSetAction.UPLOAD.toString(), "name", req.getPathTemplateValues().get("name"), "overwrite", true, "cleanup", false);
        this.configSetsHandler.handleRequestBody(req, rsp);
    }

    @EndPoint(method={SolrRequest.METHOD.PUT}, path={"/cluster/configs/{name}/*"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void insertIntoConfigSet(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String path = req.getPathTemplateValues().get("*");
        if (path == null || path.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "In order to insert a file in a configSet, a filePath must be provided in the url after the name of the configSet.");
        }
        req = ClusterAPI.wrapParams(req, "action", ConfigSetParams.ConfigSetAction.UPLOAD.toString(), "name", req.getPathTemplateValues().get("name"), "filePath", path, "overwrite", true, "cleanup", false);
        this.configSetsHandler.handleRequestBody(req, rsp);
    }

    public static SolrQueryRequest wrapParams(SolrQueryRequest req, Object ... def) {
        Map<String, Object> m = Utils.makeMap(def);
        return ClusterAPI.wrapParams(req, m);
    }

    public static SolrQueryRequest wrapParams(SolrQueryRequest req, Map m) {
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        m.forEach((k, v) -> {
            if (v == null) {
                return;
            }
            solrParams.add(k.toString(), String.valueOf(v));
        });
        DefaultSolrParams dsp = new DefaultSolrParams(req.getParams(), solrParams);
        req.setParams(dsp);
        return req;
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/command-status"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getCommandStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CollectionsHandler.CollectionOperation.REQUESTSTATUS_OP.execute(req, rsp, this.collectionsHandler);
    }

    @EndPoint(method={SolrRequest.METHOD.GET}, path={"/cluster/nodes"}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getNodes(SolrQueryRequest req, SolrQueryResponse rsp) {
        rsp.add("nodes", this.getCoreContainer().getZkController().getClusterState().getLiveNodes());
    }

    private CoreContainer getCoreContainer() {
        return this.collectionsHandler.getCoreContainer();
    }

    public static class RoleInfo
    implements ReflectMapWriter {
        @JsonProperty(required=true)
        public String node;
        @JsonProperty(required=true)
        public String role;
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/cluster"}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public class Commands {
        @Command(name="add-role")
        public void addRole(PayloadObj<RoleInfo> obj) throws Exception {
            RoleInfo info = obj.get();
            Map m = info.toMap(new HashMap<String, Object>());
            m.put("action", CollectionParams.CollectionAction.ADDROLE.toString());
            ClusterAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), m), obj.getResponse());
        }

        @Command(name="remove-role")
        public void removeRole(PayloadObj<RoleInfo> obj) throws Exception {
            RoleInfo info = obj.get();
            Map m = info.toMap(new HashMap<String, Object>());
            m.put("action", CollectionParams.CollectionAction.REMOVEROLE.toString());
            ClusterAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), m), obj.getResponse());
        }

        @Command(name="set-obj-property")
        public void setObjProperty(PayloadObj<ClusterPropInfo> obj) {
            Map<String, Object> m = obj.getDataMap();
            ClusterProperties clusterProperties = new ClusterProperties(ClusterAPI.this.getCoreContainer().getZkController().getZkClient());
            try {
                clusterProperties.setClusterProperties(m);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in API", (Throwable)e);
            }
        }

        @Command(name="set-property")
        public void setProperty(PayloadObj<Map<String, String>> obj) throws Exception {
            Map<String, Object> m = obj.getDataMap();
            m.put("action", CollectionParams.CollectionAction.CLUSTERPROP.toString());
            ClusterAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), m), obj.getResponse());
        }
    }

    @EndPoint(method={SolrRequest.METHOD.POST}, path={"/cluster/configs"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public class ConfigSetCommands {
        @Command(name="create")
        public void create(PayloadObj<CreateConfigInfo> obj) throws Exception {
            Map mapVals = obj.get().toMap(new HashMap<String, Object>());
            Map customProps = (Map)mapVals.remove("properties");
            if (customProps != null) {
                customProps.forEach((k, o) -> mapVals.put("configSetProp." + k, o));
            }
            mapVals.put("action", ConfigSetParams.ConfigSetAction.CREATE.toString());
            ClusterAPI.this.configSetsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), mapVals), obj.getResponse());
        }
    }
}

