/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.DeleteBackupPayload;
import org.apache.solr.client.solrj.request.beans.ListBackupPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/backups", "/collections/backups"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class CollectionBackupsAPI {
    private final CollectionsHandler collectionsHandler;

    public CollectionBackupsAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="list-backups")
    public void listBackups(PayloadObj<ListBackupPayload> obj) throws Exception {
        Map v1Params = obj.get().toMap(new HashMap<String, Object>());
        v1Params.put("action", CollectionParams.CollectionAction.LISTBACKUP.toLower());
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }

    @Command(name="delete-backups")
    public void deleteBackups(PayloadObj<DeleteBackupPayload> obj) throws Exception {
        Map v1Params = obj.get().toMap(new HashMap<String, Object>());
        v1Params.put("action", CollectionParams.CollectionAction.DELETEBACKUP.toLower());
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

