/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.lucene.util.SloppyMath;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class HaversineMetersEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;

    public HaversineMetersEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        return new HaversineDistance();
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        throw new IOException("This call should never occur");
    }

    public static class HaversineDistance
    implements DistanceMeasure {
        private static final long serialVersionUID = -9108154600539125566L;

        public double compute(double[] a, double[] b) throws DimensionMismatchException {
            return SloppyMath.haversinMeters((double)a[0], (double)a[1], (double)b[0], (double)b[1]);
        }
    }
}

