/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColStatus {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClusterState clusterState;
    private final ZkNodeProps props;
    private final SolrClientCache solrClientCache;
    public static final String CORE_INFO_PROP = "coreInfo";
    public static final String FIELD_INFO_PROP = "fieldInfo";
    public static final String SIZE_INFO_PROP = "sizeInfo";
    public static final String RAW_SIZE_PROP = "rawSize";
    public static final String RAW_SIZE_SUMMARY_PROP = "rawSizeSummary";
    public static final String RAW_SIZE_DETAILS_PROP = "rawSizeDetails";
    public static final String RAW_SIZE_SAMPLING_PERCENT_PROP = "rawSizeSamplingPercent";
    public static final String SEGMENTS_PROP = "segments";

    public ColStatus(SolrClientCache solrClientCache, ClusterState clusterState, ZkNodeProps props) {
        this.props = props;
        this.solrClientCache = solrClientCache;
        this.clusterState = clusterState;
    }

    public void getColStatus(NamedList<Object> results) {
        Float samplingPercent;
        String col = this.props.getStr("collection");
        Set<String> collections = col == null ? new HashSet<String>(this.clusterState.getCollectionStates().keySet()) : Collections.singleton(col);
        boolean withFieldInfo = this.props.getBool(FIELD_INFO_PROP, false);
        boolean withSegments = this.props.getBool(SEGMENTS_PROP, false);
        boolean withCoreInfo = this.props.getBool(CORE_INFO_PROP, false);
        boolean withSizeInfo = this.props.getBool(SIZE_INFO_PROP, false);
        boolean withRawSizeInfo = this.props.getBool(RAW_SIZE_PROP, false);
        boolean withRawSizeSummary = this.props.getBool(RAW_SIZE_SUMMARY_PROP, false);
        boolean withRawSizeDetails = this.props.getBool(RAW_SIZE_DETAILS_PROP, false);
        Object samplingPercentVal = this.props.get(RAW_SIZE_SAMPLING_PERCENT_PROP);
        Float f = samplingPercent = samplingPercentVal != null ? Float.valueOf(Float.parseFloat(String.valueOf(samplingPercentVal))) : null;
        if (withRawSizeSummary || withRawSizeDetails) {
            withRawSizeInfo = true;
        }
        if (withFieldInfo || withSizeInfo) {
            withSegments = true;
        }
        for (String collection : collections) {
            DocCollection coll = this.clusterState.getCollectionOrNull(collection);
            if (coll == null) continue;
            SimpleOrderedMap<Serializable> colMap = new SimpleOrderedMap<Serializable>();
            colMap.add("stateFormat", Integer.valueOf(coll.getStateFormat()));
            colMap.add("znodeVersion", Integer.valueOf(coll.getZNodeVersion()));
            TreeMap<String, Object> props = new TreeMap<String, Object>(coll.getProperties());
            props.remove("shards");
            colMap.add("properties", props);
            colMap.add("activeShards", Integer.valueOf(coll.getActiveSlices().size()));
            colMap.add("inactiveShards", Integer.valueOf(coll.getSlices().size() - coll.getActiveSlices().size()));
            results.add(collection, colMap);
            TreeSet<String> nonCompliant = new TreeSet<String>();
            SimpleOrderedMap shards = new SimpleOrderedMap();
            for (Slice s : coll.getSlices()) {
                String url;
                Map<String, RoutingRule> rules;
                SimpleOrderedMap<Object> sliceMap = new SimpleOrderedMap<Object>();
                shards.add(s.getName(), sliceMap);
                SimpleOrderedMap<Integer> replicaMap = new SimpleOrderedMap<Integer>();
                int totalReplicas = s.getReplicas().size();
                int activeReplicas = 0;
                int downReplicas = 0;
                int recoveringReplicas = 0;
                int recoveryFailedReplicas = 0;
                for (Replica r : s.getReplicas()) {
                    if (!r.isActive(this.clusterState.getLiveNodes())) {
                        ++downReplicas;
                        continue;
                    }
                    switch (r.getState()) {
                        case ACTIVE: {
                            ++activeReplicas;
                            break;
                        }
                        case DOWN: {
                            ++downReplicas;
                            break;
                        }
                        case RECOVERING: {
                            ++recoveringReplicas;
                            break;
                        }
                        case RECOVERY_FAILED: {
                            ++recoveryFailedReplicas;
                        }
                    }
                }
                replicaMap.add("total", totalReplicas);
                replicaMap.add("active", activeReplicas);
                replicaMap.add("down", downReplicas);
                replicaMap.add("recovering", recoveringReplicas);
                replicaMap.add("recovery_failed", recoveryFailedReplicas);
                sliceMap.add("state", s.getState().toString());
                if (s.getRange() != null) {
                    sliceMap.add("range", s.getRange().toString());
                }
                if ((rules = s.getRoutingRules()) != null && !rules.isEmpty()) {
                    sliceMap.add("routingRules", rules);
                }
                sliceMap.add("replicas", replicaMap);
                Replica leader = s.getLeader();
                if (leader == null) {
                    Replica replica = leader = s.getReplicas().size() > 0 ? s.getReplicas().iterator().next() : null;
                }
                if (leader == null) continue;
                SimpleOrderedMap<Object> leaderMap = new SimpleOrderedMap<Object>();
                sliceMap.add("leader", leaderMap);
                leaderMap.add("coreNode", leader.getName());
                leaderMap.addAll(leader.getProperties());
                if (!leader.isActive(this.clusterState.getLiveNodes()) || (url = ZkCoreNodeProps.getCoreUrl(leader)) == null) continue;
                try {
                    HttpSolrClient client = this.solrClientCache.getHttpSolrClient(url);
                    Throwable throwable = null;
                    try {
                        ModifiableSolrParams params = new ModifiableSolrParams();
                        params.add("qt", "/admin/segments");
                        params.add(FIELD_INFO_PROP, "true");
                        params.add(CORE_INFO_PROP, String.valueOf(withCoreInfo));
                        params.add(SIZE_INFO_PROP, String.valueOf(withSizeInfo));
                        params.add(RAW_SIZE_PROP, String.valueOf(withRawSizeInfo));
                        params.add(RAW_SIZE_SUMMARY_PROP, String.valueOf(withRawSizeSummary));
                        params.add(RAW_SIZE_DETAILS_PROP, String.valueOf(withRawSizeDetails));
                        if (samplingPercent != null) {
                            params.add(RAW_SIZE_SAMPLING_PERCENT_PROP, String.valueOf(samplingPercent));
                        }
                        QueryRequest req = new QueryRequest(params);
                        NamedList<Object> rsp = client.request(req);
                        rsp.remove("responseHeader");
                        leaderMap.add("segInfos", rsp);
                        NamedList segs = (NamedList)rsp.get(SEGMENTS_PROP);
                        if (segs != null) {
                            for (Map.Entry entry : segs) {
                                NamedList fields = (NamedList)((NamedList)entry.getValue()).get("fields");
                                if (fields != null) {
                                    for (Map.Entry fEntry : fields) {
                                        Object nc = ((NamedList)fEntry.getValue()).get("nonCompliant");
                                        if (nc == null) continue;
                                        nonCompliant.add(fEntry.getKey());
                                    }
                                }
                                if (withFieldInfo) continue;
                                ((NamedList)entry.getValue()).remove("fields");
                            }
                        }
                        if (!withSegments) {
                            rsp.remove(SEGMENTS_PROP);
                        }
                        if (withFieldInfo) continue;
                        rsp.remove("fieldInfoLegend");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (client == null) continue;
                        if (throwable != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        client.close();
                    }
                }
                catch (IOException | SolrServerException e) {
                    log.warn("Error getting details of replica segments from {}", (Object)url, (Object)e);
                }
            }
            if (nonCompliant.isEmpty()) {
                nonCompliant.add("(NONE)");
            }
            colMap.add("schemaNonCompliant", nonCompliant);
            colMap.add("shards", shards);
        }
    }
}

