/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ReplicaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloudReplicaSource
implements ReplicaSource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String[] slices;
    private List<String>[] replicas;

    private CloudReplicaSource(Builder builder) {
        String shards = builder.params.get("shards");
        if (shards != null) {
            this.withShardsParam(builder, shards);
        } else {
            this.withClusterState(builder, builder.params);
        }
    }

    private void withClusterState(Builder builder, SolrParams params) {
        ClusterState clusterState = builder.zkStateReader.getClusterState();
        String shardKeys = params.get("_route_");
        HashMap<String, Slice> sliceMap = new HashMap<String, Slice>();
        String collections = params.get("collection");
        if (collections != null) {
            List<String> collectionList = StrUtils.splitSmart(collections, ",", true);
            for (String collectionName : collectionList) {
                this.addSlices(sliceMap, clusterState, params, collectionName, shardKeys, true);
            }
        } else {
            this.addSlices(sliceMap, clusterState, params, builder.collection, shardKeys, false);
        }
        this.slices = sliceMap.keySet().toArray(new String[sliceMap.size()]);
        this.replicas = new List[this.slices.length];
        for (int i = 0; i < this.slices.length; ++i) {
            String sliceName = this.slices[i];
            this.replicas[i] = this.findReplicas(builder, null, clusterState, (Slice)sliceMap.get(sliceName));
        }
    }

    private void withShardsParam(Builder builder, String shardsParam) {
        List<String> sliceOrUrls = StrUtils.splitSmart(shardsParam, ",", true);
        this.slices = new String[sliceOrUrls.size()];
        this.replicas = new List[sliceOrUrls.size()];
        ClusterState clusterState = builder.zkStateReader.getClusterState();
        for (int i = 0; i < sliceOrUrls.size(); ++i) {
            String sliceOrUrl = sliceOrUrls.get(i);
            if (sliceOrUrl.indexOf(47) < 0) {
                this.slices[i] = sliceOrUrl;
                this.replicas[i] = this.findReplicas(builder, shardsParam, clusterState, clusterState.getCollection(builder.collection).getSlice(sliceOrUrl));
                continue;
            }
            this.replicas[i] = StrUtils.splitSmart(sliceOrUrl, "|", true);
            builder.replicaListTransformer.transform(this.replicas[i]);
            builder.hostChecker.checkWhitelist(clusterState, shardsParam, this.replicas[i]);
        }
    }

    private List<String> findReplicas(Builder builder, String shardsParam, ClusterState clusterState, Slice slice) {
        if (slice == null) {
            return Collections.emptyList();
        }
        IsLeaderPredicate isShardLeader = new IsLeaderPredicate(builder.zkStateReader, clusterState, slice.getCollection(), slice.getName());
        List list = slice.getReplicas().stream().filter(replica -> replica.isActive(clusterState.getLiveNodes())).filter(replica -> !builder.onlyNrt || replica.getType() == Replica.Type.NRT || replica.getType() == Replica.Type.TLOG && isShardLeader.test(replica)).collect(Collectors.toList());
        builder.replicaListTransformer.transform(list);
        List<String> collect = list.stream().map(Replica::getCoreUrl).collect(Collectors.toList());
        builder.hostChecker.checkWhitelist(clusterState, shardsParam, collect);
        return collect;
    }

    private void addSlices(Map<String, Slice> target, ClusterState state, SolrParams params, String collectionName, String shardKeys, boolean multiCollection) {
        DocCollection coll = state.getCollection(collectionName);
        Collection<Slice> slices = coll.getRouter().getSearchSlices(shardKeys, params, coll);
        ClientUtils.addSlices(target, collectionName, slices, multiCollection);
    }

    @Override
    public List<String> getSliceNames() {
        return Collections.unmodifiableList(Arrays.asList(this.slices));
    }

    @Override
    public List<String> getReplicasBySlice(int sliceNumber) {
        assert (sliceNumber >= 0 && sliceNumber < this.replicas.length);
        return this.replicas[sliceNumber];
    }

    @Override
    public int getSliceCount() {
        return this.slices.length;
    }

    static class Builder {
        private String collection;
        private ZkStateReader zkStateReader;
        private SolrParams params;
        private boolean onlyNrt;
        private ReplicaListTransformer replicaListTransformer;
        private HttpShardHandlerFactory.WhitelistHostChecker hostChecker;

        Builder() {
        }

        public Builder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder zkStateReader(ZkStateReader stateReader) {
            this.zkStateReader = stateReader;
            return this;
        }

        public Builder params(SolrParams params) {
            this.params = params;
            return this;
        }

        public Builder onlyNrt(boolean onlyNrt) {
            this.onlyNrt = onlyNrt;
            return this;
        }

        public Builder replicaListTransformer(ReplicaListTransformer replicaListTransformer) {
            this.replicaListTransformer = replicaListTransformer;
            return this;
        }

        public Builder whitelistHostChecker(HttpShardHandlerFactory.WhitelistHostChecker hostChecker) {
            this.hostChecker = hostChecker;
            return this;
        }

        public CloudReplicaSource build() {
            return new CloudReplicaSource(this);
        }
    }

    private static class IsLeaderPredicate
    implements Predicate<Replica> {
        private final ZkStateReader zkStateReader;
        private final ClusterState clusterState;
        private final String collectionName;
        private final String sliceName;
        private Replica shardLeader = null;

        public IsLeaderPredicate(ZkStateReader zkStateReader, ClusterState clusterState, String collectionName, String sliceName) {
            this.zkStateReader = zkStateReader;
            this.clusterState = clusterState;
            this.collectionName = collectionName;
            this.sliceName = sliceName;
        }

        @Override
        public boolean test(Replica replica) {
            if (this.shardLeader == null) {
                try {
                    this.shardLeader = this.zkStateReader.getLeaderRetry(this.collectionName, this.sliceName);
                }
                catch (InterruptedException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + this.sliceName + " in collection " + this.collectionName, (Throwable)e);
                }
                catch (SolrException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exception finding leader for shard {} in collection {}. Collection State: {}", new Object[]{this.sliceName, this.collectionName, this.clusterState.getCollectionOrNull(this.collectionName)});
                    }
                    throw e;
                }
            }
            return replica.getName().equals(this.shardLeader.getName());
        }
    }
}

