/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IterativeMergeStrategy
implements MergeStrategy {
    protected volatile ExecutorService executorService;
    protected volatile CloseableHttpClient httpClient;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void merge(ResponseBuilder rb, ShardRequest sreq) {
        rb._responseDocs = new SolrDocumentList();
        rb.onePassDistributedQuery = true;
        this.executorService = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory("IterativeMergeStrategy"));
        this.httpClient = this.getHttpClient();
        try {
            this.process(rb, sreq);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            HttpClientUtil.close((HttpClient)this.httpClient);
            this.executorService.shutdownNow();
        }
    }

    @Override
    public boolean mergesIds() {
        return true;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public boolean handlesMergeFields() {
        return false;
    }

    @Override
    public void handleMergeFields(ResponseBuilder rb, SolrIndexSearcher searcher) {
    }

    public List<Future<CallBack>> callBack(List<ShardResponse> responses, QueryRequest req) {
        ArrayList<Future<CallBack>> futures = new ArrayList<Future<CallBack>>();
        for (ShardResponse response : responses) {
            futures.add(this.executorService.submit(new CallBack(response, req)));
        }
        return futures;
    }

    public Future<CallBack> callBack(ShardResponse response, QueryRequest req) {
        return this.executorService.submit(new CallBack(response, req));
    }

    protected abstract void process(ResponseBuilder var1, ShardRequest var2) throws Exception;

    private CloseableHttpClient getHttpClient() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 128);
        params.set("maxConnectionsPerHost", 32);
        CloseableHttpClient httpClient = HttpClientUtil.createClient(params);
        return httpClient;
    }

    public class CallBack
    implements Callable<CallBack> {
        private HttpSolrClient solrClient;
        private QueryRequest req;
        private QueryResponse response;
        private ShardResponse originalShardResponse;

        public CallBack(ShardResponse originalShardResponse, QueryRequest req) {
            this.solrClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(originalShardResponse.getShardAddress()).withHttpClient((HttpClient)IterativeMergeStrategy.this.httpClient)).build();
            this.req = req;
            this.originalShardResponse = originalShardResponse;
            req.setMethod(SolrRequest.METHOD.POST);
            ModifiableSolrParams params = (ModifiableSolrParams)req.getParams();
            params.add("distrib", "false");
        }

        public QueryResponse getResponse() {
            return this.response;
        }

        public ShardResponse getOriginalShardResponse() {
            return this.originalShardResponse;
        }

        @Override
        public CallBack call() throws Exception {
            this.response = (QueryResponse)this.req.process(this.solrClient);
            return this;
        }
    }
}

