/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Sort;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.handler.export.ExportWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortQueue;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExportBuffers {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long EXCHANGE_TIMEOUT_SECONDS = 600L;
    static final String EXPORT_BUFFERS_KEY = "__eb__";
    final Buffer bufferOne;
    final Buffer bufferTwo;
    final List<LeafReaderContext> leaves;
    final ExportWriter exportWriter;
    final OutputStream os;
    final Timer writeOutputBufferTimer;
    final Timer fillerWaitTimer;
    final Timer writerWaitTimer;
    final IteratorWriter.ItemWriter rawWriter;
    final IteratorWriter.ItemWriter writer;
    final CyclicBarrier barrier;
    final int totalHits;
    Buffer fillBuffer;
    Buffer outputBuffer;
    Runnable filler;
    ExecutorService service;
    Throwable error;
    LongAdder outputCounter = new LongAdder();
    volatile boolean shutDown = false;

    ExportBuffers(ExportWriter exportWriter, List<LeafReaderContext> leaves, SolrIndexSearcher searcher, OutputStream os, final IteratorWriter.ItemWriter rawWriter, Sort sort, int queueSize, int totalHits, Timer writeOutputBufferTimer, Timer fillerWaitTimer, Timer writerWaitTimer) throws IOException {
        this.exportWriter = exportWriter;
        this.leaves = leaves;
        this.os = os;
        this.rawWriter = rawWriter;
        this.writer = new IteratorWriter.ItemWriter(){

            @Override
            public IteratorWriter.ItemWriter add(Object o) throws IOException {
                rawWriter.add(o);
                ExportBuffers.this.outputCounter.increment();
                return this;
            }
        };
        this.writeOutputBufferTimer = writeOutputBufferTimer;
        this.fillerWaitTimer = fillerWaitTimer;
        this.writerWaitTimer = writerWaitTimer;
        this.bufferOne = new Buffer(queueSize);
        this.bufferTwo = new Buffer(queueSize);
        this.totalHits = totalHits;
        this.fillBuffer = this.bufferOne;
        this.outputBuffer = this.bufferTwo;
        SortDoc writerSortDoc = exportWriter.getSortDoc(searcher, sort.getSort());
        this.bufferOne.initialize(writerSortDoc);
        this.bufferTwo.initialize(writerSortDoc);
        this.barrier = new CyclicBarrier(2, () -> this.swapBuffers());
        this.filler = () -> {
            try {
                log.debug("--- filler start {}", (Object)Thread.currentThread());
                SortDoc sortDoc = exportWriter.getSortDoc(searcher, sort.getSort());
                Buffer buffer = this.getFillBuffer();
                SortQueue queue = new SortQueue(queueSize, sortDoc);
                long lastOutputCounter = 0L;
                int count = 0;
                while (count < totalHits) {
                    log.debug("--- filler fillOutDocs in {}", (Object)this.fillBuffer);
                    exportWriter.fillOutDocs(leaves, sortDoc, queue, buffer);
                    log.debug("--- filler count={}, exchange buffer from {}", (Object)(count += buffer.outDocsIndex + 1), (Object)buffer);
                    Timer.Context timerContext = this.getFillerWaitTimer().time();
                    try {
                        this.exchangeBuffers();
                    }
                    finally {
                        timerContext.stop();
                    }
                    buffer = this.getFillBuffer();
                    if (this.outputCounter.longValue() > lastOutputCounter) {
                        lastOutputCounter = this.outputCounter.longValue();
                        this.flushOutput();
                    }
                    log.debug("--- filler got empty buffer {}", (Object)buffer);
                }
                buffer.outDocsIndex = -2;
                log.debug("--- filler final exchange buffer from {}", (Object)buffer);
                Timer.Context timerContext = this.getFillerWaitTimer().time();
                try {
                    this.exchangeBuffers();
                }
                finally {
                    timerContext.stop();
                }
                buffer = this.getFillBuffer();
                log.debug("--- filler final got buffer {}", (Object)buffer);
            }
            catch (Throwable e) {
                log.error("filler", e);
                this.error(e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.shutdownNow();
            }
        };
    }

    public void exchangeBuffers() throws Exception {
        log.debug("---- wait exchangeBuffers from {}", (Object)Thread.currentThread());
        this.barrier.await(600L, TimeUnit.SECONDS);
    }

    public void error(Throwable t) {
        this.error = t;
        this.barrier.reset();
    }

    public Throwable getError() {
        return this.error;
    }

    private void swapBuffers() {
        log.debug("--- swap buffers");
        Buffer one = this.fillBuffer;
        this.fillBuffer = this.outputBuffer;
        this.outputBuffer = one;
    }

    private void flushOutput() throws IOException {
    }

    public Buffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public Buffer getFillBuffer() {
        return this.fillBuffer;
    }

    public Timer getWriteOutputBufferTimer() {
        return this.writeOutputBufferTimer;
    }

    public Timer getFillerWaitTimer() {
        return this.fillerWaitTimer;
    }

    public Timer getWriterWaitTimer() {
        return this.writerWaitTimer;
    }

    public IteratorWriter.ItemWriter getWriter() {
        return this.writer;
    }

    public void shutdownNow() {
        if (this.service != null) {
            log.debug("--- shutting down buffers");
            this.service.shutdownNow();
            this.service = null;
        }
        this.shutDown = true;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void run(Callable<Boolean> writer) throws IOException {
        this.service = ExecutorUtil.newMDCAwareFixedThreadPool(1, new SolrNamedThreadFactory("ExportBuffers"));
        try {
            CompletableFuture.runAsync(this.filler, this.service);
            writer.call();
            log.debug("-- finished.");
        }
        catch (Exception e) {
            log.error("Exception running filler / writer", (Throwable)e);
            this.error(e);
        }
        finally {
            log.debug("--- all done, shutting down buffers");
            this.shutdownNow();
        }
    }

    static final class Buffer {
        static final int EMPTY = -1;
        static final int NO_MORE_DOCS = -2;
        int outDocsIndex = -1;
        SortDoc[] outDocs;

        public Buffer(int size) {
            this.outDocs = new SortDoc[size];
        }

        public void initialize(SortDoc proto) {
            this.outDocsIndex = -1;
            for (int i = 0; i < this.outDocs.length; ++i) {
                this.outDocs[i] = proto.copy();
            }
        }

        public String toString() {
            return "Buffer@" + Integer.toHexString(this.hashCode()) + "{outDocsIndex=" + this.outDocsIndex + '}';
        }
    }
}

