/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.ByteArrayUtf8CharSequence;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;
import org.apache.solr.handler.export.StringValue;
import org.apache.solr.schema.FieldType;

class StringFieldWriter
extends FieldWriter {
    private String field;
    private FieldType fieldType;
    private Map<Integer, SortedDocValues> lastDocValues = new HashMap<Integer, SortedDocValues>();
    private CharsRefBuilder cref = new CharsRefBuilder();
    final ByteArrayUtf8CharSequence utf8 = new ByteArrayUtf8CharSequence(new byte[0], 0, 0){

        @Override
        public String toString() {
            String str = this.utf16;
            if (str != null) {
                return str;
            }
            StringFieldWriter.this.fieldType.indexedToReadable(new BytesRef(this.buf, this.offset, this.length), StringFieldWriter.this.cref);
            this.utf16 = str = StringFieldWriter.this.cref.toString();
            return str;
        }
    };

    public StringFieldWriter(String field, FieldType fieldType) {
        this.field = field;
        this.fieldType = fieldType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(SortDoc sortDoc, LeafReader reader, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        BytesRef ref;
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (!sortValue.isPresent()) return false;
            ref = (BytesRef)sortValue.getCurrentValue();
        } else {
            SortedDocValues vals = this.lastDocValues.get(sortDoc.ord);
            if (vals == null || vals.docID() >= sortDoc.docId) {
                vals = DocValues.getSorted((LeafReader)reader, (String)this.field);
                this.lastDocValues.put(sortDoc.ord, vals);
            }
            if (vals.advance(sortDoc.docId) != sortDoc.docId) {
                return false;
            }
            int ord = vals.ordValue();
            ref = vals.lookupOrd(ord);
        }
        if (ew instanceof JavaBinCodec.BinEntryWriter) {
            ew.put((CharSequence)this.field, this.utf8.reset(ref.bytes, ref.offset, ref.length, null));
            return true;
        } else {
            String v = null;
            if (sortValue != null) {
                v = ((StringValue)sortValue).getLastString();
                if (v == null) {
                    this.fieldType.indexedToReadable(ref, this.cref);
                    v = this.cref.toString();
                    ((StringValue)sortValue).setLastString(v);
                }
            } else {
                this.fieldType.indexedToReadable(ref, this.cref);
                v = this.cref.toString();
            }
            ew.put((CharSequence)this.field, v);
        }
        return true;
    }
}

