/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequestBase;

public class LocalSolrQueryRequest
extends SolrQueryRequestBase {
    public static final Map emptyArgs = new HashMap(0, 1.0f);
    public String userPrincipalName = null;

    protected static SolrParams makeParams(String query, String qtype, int start, int limit, Map args) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry e : args.entrySet()) {
            String k = e.getKey().toString();
            Object v = e.getValue();
            if (v instanceof String[]) {
                map.put(k, (String[])v);
                continue;
            }
            map.put(k, new String[]{v.toString()});
        }
        if (query != null) {
            map.put("q", new String[]{query});
        }
        if (qtype != null) {
            map.put("qt", new String[]{qtype});
        }
        map.put("start", new String[]{Integer.toString(start)});
        map.put("rows", new String[]{Integer.toString(limit)});
        return new MultiMapSolrParams(map);
    }

    public LocalSolrQueryRequest(SolrCore core, String query, String qtype, int start, int limit, Map args) {
        super(core, LocalSolrQueryRequest.makeParams(query, qtype, start, limit, args));
    }

    public LocalSolrQueryRequest(SolrCore core, NamedList args) {
        super(core, args.toSolrParams());
    }

    public LocalSolrQueryRequest(SolrCore core, Map<String, String[]> args) {
        super(core, new MultiMapSolrParams(args));
    }

    public LocalSolrQueryRequest(SolrCore core, SolrParams args) {
        super(core, args);
    }

    @Override
    public Principal getUserPrincipal() {
        return new LocalPrincipal(this.userPrincipalName);
    }

    public void setUserPrincipalName(String s) {
        this.userPrincipalName = s;
    }

    private final class LocalPrincipal
    implements Principal {
        private final String user;

        public LocalPrincipal(String user) {
            this.user = user;
        }

        @Override
        public String getName() {
            return this.user;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.user);
        }

        @Override
        public boolean equals(Object other) {
            return Objects.equals(this.getClass(), other.getClass()) && Objects.equals(this.getName(), ((LocalPrincipal)other).getName());
        }
    }
}

