/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.Iterator;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.transform.WriteableGeoJSON;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.io.SupportedFormats;
import org.locationtech.spatial4j.shape.Shape;

class GeoFieldUpdater {
    String field;
    String display;
    String display_error;
    boolean isJSON;
    ShapeWriter writer;
    SupportedFormats formats;

    GeoFieldUpdater() {
    }

    void addShape(SolrDocument doc, Shape shape) {
        if (this.isJSON) {
            doc.addField(this.display, new WriteableGeoJSON(shape, this.writer));
        } else {
            doc.addField(this.display, this.writer.toString(shape));
        }
    }

    void setValue(SolrDocument doc, Object val) {
        doc.remove(this.display);
        if (val != null) {
            if (val instanceof Iterable) {
                Iterator iter = ((Iterable)val).iterator();
                while (iter.hasNext()) {
                    this.addValue(doc, iter.next());
                }
            } else {
                this.addValue(doc, val);
            }
        }
    }

    void addValue(SolrDocument doc, Object val) {
        if (val == null) {
            return;
        }
        if (val instanceof Shape) {
            this.addShape(doc, (Shape)val);
        } else if (val instanceof Exception) {
            doc.setField(this.display_error, ((Exception)val).toString());
        } else {
            if (val instanceof IndexableField) {
                val = ((IndexableField)val).stringValue();
            }
            try {
                this.addShape(doc, this.formats.read(val.toString()));
            }
            catch (Exception ex) {
                doc.setField(this.display_error, ex.toString());
            }
        }
    }
}

