/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.params.ShardParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.distributed.shardresultserializer.TopGroupsResultTransformer;

public class TopGroupsShardResponseProcessor
implements ShardResponseProcessor {
    @Override
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        int n;
        Sort groupSort = rb.getGroupingSpec().getGroupSortSpec().getSort();
        String[] fields = rb.getGroupingSpec().getFields();
        String[] queries = rb.getGroupingSpec().getQueries();
        SortSpec withinGroupSortSpec = rb.getGroupingSpec().getWithinGroupSortSpec();
        Sort withinGroupSort = withinGroupSortSpec.getSort();
        assert (withinGroupSort != null);
        boolean simpleOrMain = rb.getGroupingSpec().getResponseFormat() == Grouping.Format.simple || rb.getGroupingSpec().isMain();
        int groupOffsetDefault = simpleOrMain ? 0 : withinGroupSortSpec.getOffset();
        int docsPerGroupDefault = withinGroupSortSpec.getCount();
        HashMap commandTopGroups = new HashMap();
        for (String field : fields) {
            commandTopGroups.put(field, new ArrayList());
        }
        HashMap commandTopDocs = new HashMap();
        for (String string : queries) {
            commandTopDocs.put(string, new ArrayList());
        }
        TopGroupsResultTransformer serializer = new TopGroupsResultTransformer(rb);
        SimpleOrderedMap shardInfo = null;
        if (rb.req.getParams().getBool("shards.info", false)) {
            shardInfo = new SimpleOrderedMap();
            rb.rsp.getValues().add("shards.info", shardInfo);
        }
        for (ShardResponse shardResponse : shardRequest.responses) {
            SimpleOrderedMap<Object> individualShardInfo = null;
            if (shardInfo != null) {
                individualShardInfo = new SimpleOrderedMap<Object>();
                if (shardResponse.getException() != null) {
                    Throwable t = shardResponse.getException();
                    if (t instanceof SolrServerException && ((SolrServerException)t).getCause() != null) {
                        t = ((SolrServerException)t).getCause();
                    }
                    individualShardInfo.add("error", t.toString());
                    StringWriter trace = new StringWriter();
                    t.printStackTrace(new PrintWriter(trace));
                    individualShardInfo.add("trace", trace.toString());
                }
                if (shardResponse.getSolrResponse() != null) {
                    individualShardInfo.add("time", shardResponse.getSolrResponse().getElapsedTime());
                }
                if (shardResponse.getShardAddress() != null) {
                    individualShardInfo.add("shardAddress", shardResponse.getShardAddress());
                }
                shardInfo.add(shardResponse.getShard(), individualShardInfo);
            }
            if (ShardParams.getShardsTolerantAsBool(rb.req.getParams()) && shardResponse.getException() != null) {
                rb.rsp.getResponseHeader().asShallowMap().put("partialResults", Boolean.TRUE);
                continue;
            }
            NamedList secondPhaseResult = (NamedList)shardResponse.getSolrResponse().getResponse().get("secondPhase");
            if (secondPhaseResult == null) continue;
            Object result = serializer.transformToNative(secondPhaseResult, groupSort, withinGroupSort, shardResponse.getShard());
            int numFound = 0;
            float maxScore = Float.NaN;
            for (Map.Entry entry : commandTopGroups.entrySet()) {
                TopGroups topGroups = (TopGroups)result.get(entry.getKey());
                if (topGroups == null) continue;
                if (individualShardInfo != null) {
                    numFound += topGroups.totalHitCount;
                    if (Float.isNaN(maxScore) || topGroups.maxScore > maxScore) {
                        maxScore = topGroups.maxScore;
                    }
                }
                ((List)entry.getValue()).add(topGroups);
            }
            for (String query : queries) {
                QueryCommandResult queryCommandResult = (QueryCommandResult)result.get(query);
                if (individualShardInfo != null) {
                    numFound += queryCommandResult.getMatches();
                    float thisMax = queryCommandResult.getMaxScore();
                    if (Float.isNaN(maxScore) || thisMax > maxScore) {
                        maxScore = thisMax;
                    }
                }
                ((List)commandTopDocs.get(query)).add(queryCommandResult);
            }
            if (individualShardInfo == null) continue;
            individualShardInfo.add("numFound", numFound);
            individualShardInfo.add("maxScore", Float.valueOf(maxScore));
        }
        for (Map.Entry entry : commandTopGroups.entrySet()) {
            List topGroups = (List)entry.getValue();
            if (topGroups.isEmpty()) continue;
            TopGroups[] topGroupsArr = new TopGroups[topGroups.size()];
            int docsPerGroup = docsPerGroupDefault;
            if (docsPerGroup < 0) {
                docsPerGroup = 0;
                for (TopGroups subTopGroups : topGroups) {
                    docsPerGroup += subTopGroups.totalGroupedHitCount;
                }
            }
            rb.mergedTopGroups.put((String)entry.getKey(), (TopGroups<BytesRef>)TopGroups.merge((TopGroups[])topGroups.toArray(topGroupsArr), (Sort)groupSort, (Sort)withinGroupSort, (int)groupOffsetDefault, (int)docsPerGroup, (TopGroups.ScoreMergeMode)TopGroups.ScoreMergeMode.None));
        }
        int topN = docsPerGroupDefault >= 0 ? docsPerGroupDefault : Integer.MAX_VALUE;
        int n2 = groupOffsetDefault;
        if (simpleOrMain) {
            n = rb.getGroupingSpec().getGroupSortSpec().getOffset();
            int limit = rb.getGroupingSpec().getGroupSortSpec().getCount();
            topN = limit >= 0 ? limit : Integer.MAX_VALUE;
        }
        for (Map.Entry entry : commandTopDocs.entrySet()) {
            List queryCommandResults = (List)entry.getValue();
            ArrayList<TopDocs> topDocs = new ArrayList<TopDocs>(queryCommandResults.size());
            int mergedMatches = 0;
            float maxScore = Float.NaN;
            for (QueryCommandResult queryCommandResult : queryCommandResults) {
                TopDocs thisTopDocs = queryCommandResult.getTopDocs();
                topDocs.add(thisTopDocs);
                mergedMatches += queryCommandResult.getMatches();
                if (thisTopDocs.scoreDocs.length <= 0) continue;
                float thisMaxScore = queryCommandResult.getMaxScore();
                if (!Float.isNaN(maxScore) && !(thisMaxScore > maxScore)) continue;
                maxScore = thisMaxScore;
            }
            Object mergedTopDocs = withinGroupSort.equals((Object)Sort.RELEVANCE) ? TopDocs.merge((int)n, (int)topN, (TopDocs[])topDocs.toArray(new TopDocs[topDocs.size()]), (boolean)true) : TopDocs.merge((Sort)withinGroupSort, (int)n, (int)topN, (TopFieldDocs[])topDocs.toArray(new TopFieldDocs[topDocs.size()]), (boolean)true);
            rb.mergedQueryCommandResults.put((String)entry.getKey(), new QueryCommandResult((TopDocs)mergedTopDocs, mergedMatches, maxScore));
        }
        TopGroupsShardResponseProcessor.fillResultIds(rb);
    }

    static void fillResultIds(ResponseBuilder rb) {
        HashMap<Object, ShardDoc> resultIds = new HashMap<Object, ShardDoc>();
        int i = 0;
        for (TopGroups<BytesRef> topGroups : rb.mergedTopGroups.values()) {
            for (GroupDocs groupDocs : topGroups.groups) {
                for (ScoreDoc scoreDoc : groupDocs.scoreDocs) {
                    ShardDoc solrDoc = (ShardDoc)scoreDoc;
                    if (resultIds.containsKey(solrDoc.id)) continue;
                    solrDoc.positionInResponse = i++;
                    resultIds.put(solrDoc.id, solrDoc);
                }
            }
        }
        for (QueryCommandResult queryCommandResult : rb.mergedQueryCommandResults.values()) {
            for (GroupDocs groupDocs : queryCommandResult.getTopDocs().scoreDocs) {
                ShardDoc solrDoc = (ShardDoc)groupDocs;
                solrDoc.positionInResponse = i++;
                resultIds.put(solrDoc.id, solrDoc);
            }
        }
        rb.resultIds = resultIds;
    }
}

